/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.HashSet;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;

public class ScopeUtils {
    public static boolean isValidScopeData(IExtensibleElement extensible, String dataPath, DataType data) {
        boolean valid = true;
        ModelType model = ModelUtils.findContainingModel(extensible);
        String dataId = AttributeUtil.getAttributeValue(extensible, "carnot:engine:dataId");
        if (StringUtils.isEmpty((String)dataId) && data == null) {
            valid = false;
        } else {
            if (data == null) {
                data = ModelUtils.findElementById(model.getData(), dataId);
            }
            if (data != null) {
                if (data.getType().getId().equals("struct")) {
                    if (dataPath == null) {
                        dataPath = AttributeUtil.getAttributeValue(extensible, "carnot:engine:dataPath");
                    }
                    if (StringUtils.isEmpty((String)dataPath)) {
                        valid = false;
                    } else {
                        TypeDeclarationType type = StructuredTypeUtils.getTypeDeclaration(data);
                        if (type == null) {
                            valid = false;
                        } else {
                            IXPathMap xPathMap = StructuredTypeUtils.getXPathMap(data);
                            if (StructuredDataXPathUtils.returnSinglePrimitiveType((String)dataPath, (IXPathMap)xPathMap) != 8) {
                                valid = false;
                            }
                        }
                    }
                } else if (data.getType().getId().equals("primitive")) {
                    String type = AttributeUtil.getAttributeValue(data, "carnot:engine:type");
                    if (Type.String.equals((Object)type)) {
                        if (dataPath == null) {
                            dataPath = AttributeUtil.getAttributeValue(extensible, "carnot:engine:dataPath");
                        }
                        if (!StringUtils.isEmpty((String)dataPath)) {
                            valid = false;
                        }
                    } else {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
            } else {
                valid = false;
            }
        }
        return valid;
    }

    public static boolean isValidScopedParticipantForManualTrigger(IModelParticipant participant) {
        OrganizationType organization = ScopeUtils.findScopedOrganizationForParticipant(participant);
        return ScopeUtils.isValidScopeData(organization, null, null);
    }

    public static HashSet<IModelParticipant> findScopedParticipants(ModelType model) {
        HashSet<IModelParticipant> scoped = new HashSet<IModelParticipant>();
        for (OrganizationType organization : model.getOrganization()) {
            if (!AttributeUtil.getBooleanValue(organization, "carnot:engine:bound")) continue;
            ScopeUtils.collectChildren(organization, scoped);
        }
        return scoped;
    }

    public static OrganizationType findScopedOrganizationForParticipant(IModelParticipant element) {
        if (element instanceof OrganizationType && AttributeUtil.getBooleanValue(element, "carnot:engine:bound")) {
            return (OrganizationType)element;
        }
        ModelType model = ModelUtils.findContainingModel(element);
        OrganizationType parent = null;
        block0: for (OrganizationType organization : model.getOrganization()) {
            RoleType teamLead = organization.getTeamLead();
            if (teamLead != null && teamLead.equals(element)) {
                parent = organization;
            }
            if (parent != null) continue;
            for (ParticipantType participant : organization.getParticipant()) {
                IModelParticipant childParticipant = participant.getParticipant();
                if (!childParticipant.equals(element)) continue;
                parent = organization;
                continue block0;
            }
        }
        if (parent == null) {
            return null;
        }
        if (AttributeUtil.getBooleanValue(parent, "carnot:engine:bound")) {
            return parent;
        }
        return ScopeUtils.findScopedParent(parent);
    }

    private static OrganizationType findScopedParent(OrganizationType element) {
        ModelType model = ModelUtils.findContainingModel(element);
        for (OrganizationType organization : model.getOrganization()) {
            for (ParticipantType participant : organization.getParticipant()) {
                IModelParticipant childParticipant = participant.getParticipant();
                if (!(childParticipant instanceof OrganizationType) || !childParticipant.equals(element)) continue;
                if (AttributeUtil.getBooleanValue(organization, "carnot:engine:bound")) {
                    return organization;
                }
                return ScopeUtils.findScopedParent(organization);
            }
        }
        return null;
    }

    private static void collectChildren(OrganizationType organization, HashSet<IModelParticipant> scoped) {
        scoped.add(organization);
        RoleType teamLead = organization.getTeamLead();
        if (teamLead != null) {
            scoped.add(teamLead);
        }
        for (ParticipantType participant : organization.getParticipant()) {
            IModelParticipant childParticipant = participant.getParticipant();
            if (childParticipant instanceof OrganizationType && !scoped.contains(childParticipant)) {
                ScopeUtils.collectChildren((OrganizationType)childParticipant, scoped);
            }
            scoped.add(childParticipant);
        }
    }
}

