/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.engine.core.model.beans.QNameUtil;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;

public class TypeDeclarationUtils {
    public static final int XPDL_TYPE = 0;
    public static final int SIMPLE_TYPE = 1;
    public static final int COMPLEX_TYPE = 2;
    public static ThreadLocal<URIConverter> defaultURIConverter = new ThreadLocal();
    private static Set<String> reservedPrefixes = TypeDeclarationUtils.reserve("xml", "xsd");

    public static void updateTypeDefinition(TypeDeclarationType declaration, String newId, String previousId) {
        ModelType model = ModelUtils.findContainingModel(declaration);
        XSDSchema clone = declaration.getSchema();
        Map prefixes = clone.getQNamePrefixToNamespaceMap();
        ArrayList<String> addPrefixes = new ArrayList<String>();
        HashSet set = new HashSet(prefixes.entrySet());
        for (Map.Entry entry : set) {
            int idx;
            if (((String)entry.getKey()).equals("xsd")) continue;
            Set elements = CollectionUtils.newSet();
            String value = (String)entry.getValue();
            String elementName = value.substring(idx = value.lastIndexOf("/") + 1, value.length());
            if (!elementName.equals(previousId)) continue;
            TypeDeclarationUtils.removeNameSpace(clone, elementName, model.getId());
            String prefix = TypeDeclarationUtils.computePrefix(newId, clone.getQNamePrefixToNamespaceMap().keySet());
            if (!addPrefixes.contains(prefix)) {
                String nameSpace = TypeDeclarationUtils.computeTargetNamespace(model, newId);
                addPrefixes.add(prefix);
                clone.getQNamePrefixToNamespaceMap().put(prefix, nameSpace);
            }
            TypeDeclarationUtils.findElementsForType(declaration, elements, previousId);
            for (XSDElementDeclaration elementDeclaration : elements) {
                elementDeclaration.setTypeDefinition(null);
            }
            XSDTypeDefinition definition = TypeDeclarationUtils.getTypeDefinition(model.getTypeDeclarations(), newId);
            if (definition == null) continue;
            for (XSDElementDeclaration elementDeclaration : elements) {
                elementDeclaration.setTypeDefinition(definition);
            }
        }
        clone.updateElement(true);
    }

    private static Set<String> reserve(String ... values) {
        Set reserved = CollectionUtils.newSet();
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                reserved.add(string);
                ++n2;
            }
        }
        return reserved;
    }

    public static boolean fixImport(TypeDeclarationType typeDeclaration, String newId, String previousId) {
        XSDSchema schema;
        List<XSDImport> xsdImports;
        boolean match = false;
        XpdlTypeType type = typeDeclaration.getDataType();
        if (type instanceof SchemaTypeType && (xsdImports = TypeDeclarationUtils.getImports(schema = ((SchemaTypeType)type).getSchema())) != null) {
            for (XSDImport xsdImport : xsdImports) {
                if (!xsdImport.getSchemaLocation().startsWith("urn:internal:")) continue;
                int idx = xsdImport.getSchemaLocation().lastIndexOf("urn:internal:") + "urn:internal:".length();
                String elementName = xsdImport.getSchemaLocation().substring(idx, xsdImport.getSchemaLocation().length());
                if (!elementName.equals(previousId)) continue;
                match = true;
                xsdImport.setSchemaLocation("urn:internal:" + newId);
                xsdImport.setNamespace(TypeDeclarationUtils.computeTargetNamespace(ModelUtils.findContainingModel(typeDeclaration), newId));
            }
        }
        return match;
    }

    public static String computeTargetNamespace(ModelType model, String id) {
        return TypeDeclarationUtils.computeTargetNamespace(model.getId(), id);
    }

    public static String computeTargetNamespace(String modelId, String id) {
        return "http://www.infinity.com/bpm/model/" + TypeDeclarationUtils.encode(modelId) + "/" + TypeDeclarationUtils.encode(id);
    }

    private static String encode(String id) {
        try {
            id = new java.net.URI(id).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {}
        return id;
    }

    public static List<TypeDeclarationType> filterTypeDeclarations(List<TypeDeclarationType> declarations, int type) {
        ArrayList<TypeDeclarationType> result = new ArrayList<TypeDeclarationType>();
        for (TypeDeclarationType declaration : declarations) {
            if (type != TypeDeclarationUtils.getType(declaration)) continue;
            result.add(declaration);
        }
        return result;
    }

    public static XSDNamedComponent findElementOrTypeDeclaration(TypeDeclarationType declaration) {
        return TypeDeclarationUtils.findElementOrTypeDeclaration(declaration, declaration.getId());
    }

    public static XSDNamedComponent findElementOrTypeDeclaration(TypeDeclarationType declaration, String id) {
        XpdlTypeType type = declaration.getDataType();
        XSDSchema schema = declaration.getSchema();
        if (schema != null) {
            if (type instanceof SchemaTypeType) {
                return TypeDeclarationUtils.findElementOrTypeDeclaration(schema, id, schema.getTargetNamespace(), true);
            }
            if (type instanceof ExternalReferenceType) {
                ExternalReferenceType reference = (ExternalReferenceType)type;
                return TypeDeclarationUtils.findElementOrTypeDeclaration(schema, QNameUtil.parseLocalName((String)reference.getXref()), QNameUtil.parseNamespaceURI((String)reference.getXref()), false);
            }
        }
        return null;
    }

    public static XSDNamedComponent findElementOrTypeDeclaration(XSDSchema schema, String localName, String namespace, boolean returnFirstIfNoMatch) {
        if (schema == null) {
            return null;
        }
        XSDNamedComponent decl = null;
        EList elements = schema.getElementDeclarations();
        EList types = schema.getTypeDefinitions();
        if (localName != null) {
            for (XSDElementDeclaration element : elements) {
                if (!localName.equals(element.getName()) || !CompareHelper.areEqual((Object)namespace, (Object)element.getTargetNamespace())) continue;
                decl = element;
                break;
            }
            if (decl == null) {
                for (XSDTypeDefinition type : types) {
                    if (!localName.equals(type.getName()) || !CompareHelper.areEqual((Object)namespace, (Object)type.getTargetNamespace())) continue;
                    decl = type;
                    break;
                }
            }
        }
        if (decl == null && returnFirstIfNoMatch) {
            if (elements.size() == 1) {
                decl = (XSDNamedComponent)elements.get(0);
            } else if (elements.isEmpty() && types.size() == 1) {
                decl = (XSDNamedComponent)types.get(0);
            }
        }
        return decl;
    }

    public static TypeDeclarationType findTypeDeclarationByLocation(TypeDeclarationsType declarations, String location) {
        if (declarations == null || location == null) {
            return null;
        }
        if (location.startsWith("urn:internal:")) {
            String typeId = location.substring("urn:internal:".length());
            return ModelUtils.findElementById(declarations.getTypeDeclaration(), typeId);
        }
        return null;
    }

    public static XSDSchema getSchema(String location, String namespaceURI) throws IOException {
        XSDSchema schema;
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        URI uri = null;
        uri = Platform.isRunning() ? (!location.toLowerCase().startsWith("http://") ? URI.createPlatformResourceURI((String)location, (boolean)true) : URI.createURI((String)location)) : URI.createURI((String)location);
        ResourceSet resourceSet = XSDSchemaImpl.createResourceSet();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("wsdl", extensionToFactoryMap.get("xsd"));
        URIConverter converter = defaultURIConverter.get();
        if (converter != null) {
            resourceSet.setURIConverter(converter);
        }
        Resource resource = resourceSet.createResource(URI.createURI((String)"*.xsd"));
        resource.setURI(uri);
        resource.load(options);
        boolean hasSchema = false;
        for (Object eObject : resource.getContents()) {
            if (!(eObject instanceof XSDSchema)) continue;
            hasSchema = true;
            schema = (XSDSchema)eObject;
            if (!CompareHelper.areEqual((Object)namespaceURI, (Object)schema.getTargetNamespace())) continue;
            TypeDeclarationUtils.resolveImports(schema);
            return schema;
        }
        if (hasSchema) {
            for (Object eObject : resource.getContents()) {
                if (!(eObject instanceof XSDSchema)) continue;
                schema = (XSDSchema)eObject;
                for (XSDSchemaContent item : schema.getContents()) {
                    XSDImportImpl directive;
                    XSDSchema ref;
                    if (!(item instanceof XSDImportImpl) || (ref = (directive = (XSDImportImpl)item).importSchema()) == null || !CompareHelper.areEqual((Object)namespaceURI, (Object)ref.getTargetNamespace())) continue;
                    TypeDeclarationUtils.resolveImports(schema);
                    return schema;
                }
            }
        }
        return null;
    }

    public static boolean isInternalSchema(TypeDeclarationType declaration) {
        XpdlTypeType type = declaration.getDataType();
        if (type instanceof SchemaTypeType) {
            return true;
        }
        if (type instanceof ExternalReferenceType) {
            String externalUrl = ((ExternalReferenceType)type).getLocation();
            return externalUrl != null && externalUrl.startsWith("urn:internal:");
        }
        return false;
    }

    public static XSDSimpleTypeDefinition getSimpleType(TypeDeclarationType declaration) {
        XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration(declaration);
        if (component instanceof XSDElementDeclaration) {
            component = ((XSDElementDeclaration)component).getTypeDefinition();
        }
        return component instanceof XSDSimpleTypeDefinition ? (XSDSimpleTypeDefinition)component : null;
    }

    public static XSDComplexTypeDefinition getComplexType(TypeDeclarationType declaration) {
        XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration(declaration);
        if (component instanceof XSDElementDeclaration) {
            component = ((XSDElementDeclaration)component).getTypeDefinition();
        }
        return component instanceof XSDComplexTypeDefinition ? (XSDComplexTypeDefinition)component : null;
    }

    public static int getType(TypeDeclarationType declaration) {
        XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration(declaration);
        if (component instanceof XSDElementDeclaration) {
            component = ((XSDElementDeclaration)component).getTypeDefinition();
        }
        if (component instanceof XSDSimpleTypeDefinition) {
            return 1;
        }
        if (component instanceof XSDComplexTypeDefinition) {
            return 2;
        }
        return 0;
    }

    public static String computePrefix(String name, Set<String> usedPrefixes) {
        String prefix;
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() == 0) {
            prefix = "p";
        } else {
            int pos = name.length();
            while (pos > 0 && Character.isDigit(name.charAt(pos - 1))) {
                --pos;
            }
            int nch = 3;
            if (nch > pos) {
                nch = pos;
            }
            prefix = (String.valueOf(name.substring(0, nch)) + name.substring(pos)).toLowerCase();
        }
        if (reservedPrefixes.contains(prefix)) {
            prefix = "px";
        }
        if (usedPrefixes.contains(prefix)) {
            int counter = 1;
            while (usedPrefixes.contains(String.valueOf(prefix) + counter)) {
                ++counter;
            }
            prefix = String.valueOf(prefix) + counter;
        }
        return prefix;
    }

    public static void updateImports(XSDSchema xsdSchema, String oldTargetNamespace, String oldId, String id) {
        for (XSDSchemaDirective directive : xsdSchema.getReferencingDirectives()) {
            directive.setSchemaLocation(xsdSchema.getSchemaLocation());
            if (directive instanceof XSDImport) {
                ((XSDImport)directive).setNamespace(xsdSchema.getTargetNamespace());
            }
            XSDSchema referencingSchema = directive.getSchema();
            List toRemove = CollectionUtils.newList();
            Map prefixes = referencingSchema.getQNamePrefixToNamespaceMap();
            List<XSDImport> imports = TypeDeclarationUtils.getImports(referencingSchema);
            if (imports != null && !imports.isEmpty()) {
                for (XSDImport xsdImport : imports) {
                    if (!xsdImport.getSchemaLocation().endsWith(":" + oldId)) continue;
                    xsdImport.setSchemaLocation("urn:internal:" + id);
                }
            }
            String newPrefix = TypeDeclarationUtils.computePrefix(id, prefixes.keySet());
            prefixes.put(newPrefix, xsdSchema.getTargetNamespace());
            for (Map.Entry entry : prefixes.entrySet()) {
                if (newPrefix.equals(entry.getKey()) || !oldTargetNamespace.equals(entry.getValue())) continue;
                toRemove.add((String)entry.getKey());
            }
            for (String prefix : toRemove) {
                prefixes.remove(prefix);
            }
        }
    }

    public static List<XSDImport> getImports(XSDSchema schema) {
        ArrayList<XSDImport> xsdImports = new ArrayList<XSDImport>();
        EList contents = schema.getContents();
        for (XSDSchemaContent content : contents) {
            if (!(content instanceof XSDImport)) continue;
            xsdImports.add((XSDImport)content);
        }
        if (!xsdImports.isEmpty()) {
            return xsdImports;
        }
        return null;
    }

    public static boolean hasImport(XSDSchema schema, TypeDeclarationType type) {
        for (XSDSchemaContent content : schema.getContents()) {
            String typeId;
            String location;
            if (!(content instanceof XSDImport) || !(location = ((XSDImport)content).getSchemaLocation()).startsWith("urn:internal:") || !(typeId = location.substring("urn:internal:".length())).equals(type.getId())) continue;
            return true;
        }
        return false;
    }

    public static XSDImport removeImport(XSDSchema schema, XSDSchema importedSchema) {
        XSDImport removeImport = null;
        for (XSDSchemaContent content : schema.getContents()) {
            XSDImport xsdImport;
            if (!(content instanceof XSDImport) || (xsdImport = (XSDImport)content).getResolvedSchema() != importedSchema || !xsdImport.getSchemaLocation().startsWith("urn:internal:")) continue;
            removeImport = xsdImport;
            break;
        }
        if (removeImport != null) {
            schema.getContents().remove(removeImport);
        }
        return removeImport;
    }

    public static XSDTypeDefinition getTypeDefinition(TypeDeclarationsType declarations, String name) {
        XSDSchema schema;
        TypeDeclarationType td = declarations.getTypeDeclaration(name);
        if (td != null && (schema = td.getSchema()) != null) {
            for (XSDTypeDefinition definition : schema.getTypeDefinitions()) {
                if (!definition.getName().equals(name)) continue;
                return definition;
            }
        }
        return null;
    }

    public static void findElementsForType(TypeDeclarationType declaration, Set<XSDElementDeclaration> elements, String elementName) {
        XSDComplexTypeDefinition complexType = TypeDeclarationUtils.getComplexType(declaration);
        if (complexType != null) {
            TypeDeclarationUtils.visit(complexType, elements, elementName);
        }
    }

    public static void visit(XSDComplexTypeDefinition complexType, Set<XSDElementDeclaration> elements, String elementName) {
        XSDComplexTypeContent content = complexType.getContent();
        if (content instanceof XSDParticle) {
            TypeDeclarationUtils.visit((XSDParticle)content, elements, elementName);
        }
    }

    public static void visit(XSDParticle particle, Set<XSDElementDeclaration> elements, String elementName) {
        XSDParticleContent particleContent = particle.getContent();
        if (!(particleContent instanceof XSDModelGroupDefinition) && particleContent instanceof XSDTerm) {
            TypeDeclarationUtils.visit((XSDTerm)particleContent, elements, elementName);
        }
    }

    public static void visit(XSDTerm term, Set<XSDElementDeclaration> elements, String elementName) {
        if (term instanceof XSDElementDeclaration) {
            TypeDeclarationUtils.visit((XSDElementDeclaration)term, elements, elementName);
        } else if (term instanceof XSDModelGroup) {
            TypeDeclarationUtils.visit((XSDModelGroup)term, elements, elementName);
        }
    }

    public static void visit(XSDModelGroup group, Set<XSDElementDeclaration> elements, String elementName) {
        for (XSDParticle xsdParticle : group.getContents()) {
            TypeDeclarationUtils.visit(xsdParticle, elements, elementName);
        }
    }

    public static void visit(XSDElementDeclaration element, Set<XSDElementDeclaration> elements, String elementName) {
        String qName;
        XSDTypeDefinition type = element.getAnonymousTypeDefinition();
        if (type instanceof XSDComplexTypeDefinition) {
            TypeDeclarationUtils.visit((XSDComplexTypeDefinition)type, elements, elementName);
        } else if (type == null && (type = element.getType()) != null && elementName.equals(qName = type.getQName())) {
            elements.add(element);
        }
    }

    public static void resolveImports(XSDSchema schema) {
        EList contents = schema.getContents();
        for (XSDSchemaContent item : contents) {
            if (!(item instanceof XSDImportImpl)) continue;
            ((XSDImportImpl)item).importSchema();
        }
    }

    public static void removeNameSpace(XSDSchema schema, String oldDefName, String modelId) {
        String targetNameSpace = TypeDeclarationUtils.computeTargetNamespace(modelId, oldDefName);
        String prefix = TypeDeclarationUtils.getNamespacePrefix(schema, targetNameSpace);
        if (prefix != null) {
            schema.getQNamePrefixToNamespaceMap().remove(prefix);
        }
    }

    public static String getNamespacePrefix(XSDSchema schema, String targetNameSpace) {
        String prefix = null;
        for (Map.Entry entry : schema.getQNamePrefixToNamespaceMap().entrySet()) {
            if (!((String)entry.getValue()).equals(targetNameSpace)) continue;
            prefix = (String)entry.getKey();
            break;
        }
        return prefix;
    }

    public static void collectAllNamespaces(XSDSchema schema, Map<String, String> qNamePrefixToNamespaceMap) {
        List<XSDImport> imports = TypeDeclarationUtils.getImports(schema);
        if (imports != null) {
            for (XSDImport xsdImport : imports) {
                XSDSchema importetSchema;
                if (!xsdImport.getSchemaLocation().startsWith("urn:internal:") || (importetSchema = xsdImport.getResolvedSchema()) == null) continue;
                String targetNamespace = importetSchema.getTargetNamespace();
                String namespacePrefix = TypeDeclarationUtils.getNamespacePrefix(importetSchema, targetNamespace);
                if (qNamePrefixToNamespaceMap.containsValue(targetNamespace)) continue;
                qNamePrefixToNamespaceMap.put(namespacePrefix, targetNamespace);
                TypeDeclarationUtils.collectAllNamespaces(importetSchema, qNamePrefixToNamespaceMap);
            }
        }
    }
}

