/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImplementationType implements Enumerator
{
    ENGINE_LITERAL(0, "engine", "engine"),
    PULL_LITERAL(1, "pull", "pull"),
    PUSH_LITERAL(2, "push", "push");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int ENGINE = 0;
    public static final int PULL = 1;
    public static final int PUSH = 2;
    private static final ImplementationType[] VALUES_ARRAY;
    public static final List<ImplementationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ImplementationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ImplementationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ImplementationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ImplementationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ImplementationType get(int value) {
        switch (value) {
            case 0: {
                return ENGINE_LITERAL;
            }
            case 1: {
                return PULL_LITERAL;
            }
            case 2: {
                return PUSH_LITERAL;
            }
        }
        return null;
    }

    private ImplementationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ImplementationType[]{ENGINE_LITERAL, PULL_LITERAL, PUSH_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

