/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LinkColor implements Enumerator
{
    UNKNOWN_LITERAL(-1, "", ""),
    BLACK_LITERAL(0, "black", "black"),
    DARK_BLUE_LITERAL(1, "dark blue", "dark blue"),
    DARK_GRAY_LITERAL(2, "dark gray", "dark gray"),
    BLUE_LITERAL(3, "blue", "blue"),
    LIGHT_GRAY_LITERAL(4, "light gray", "light gray"),
    RED_LITERAL(5, "red", "red"),
    YELLOW_LITERAL(6, "yellow", "yellow");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int UNKNOWN = -1;
    public static final int BLACK = 0;
    public static final int DARK_BLUE = 1;
    public static final int DARK_GRAY = 2;
    public static final int BLUE = 3;
    public static final int LIGHT_GRAY = 4;
    public static final int RED = 5;
    public static final int YELLOW = 6;
    private static final LinkColor[] VALUES_ARRAY;
    public static final List<LinkColor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LinkColor get(String literal) {
        if ("ligth gray".equals(literal)) {
            return LIGHT_GRAY_LITERAL;
        }
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LinkColor result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LinkColor getByName(String name) {
        if ("ligth gray".equals(name)) {
            return LIGHT_GRAY_LITERAL;
        }
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LinkColor result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LinkColor get(int value) {
        switch (value) {
            case -1: {
                return UNKNOWN_LITERAL;
            }
            case 0: {
                return BLACK_LITERAL;
            }
            case 1: {
                return DARK_BLUE_LITERAL;
            }
            case 2: {
                return DARK_GRAY_LITERAL;
            }
            case 3: {
                return BLUE_LITERAL;
            }
            case 4: {
                return LIGHT_GRAY_LITERAL;
            }
            case 5: {
                return RED_LITERAL;
            }
            case 6: {
                return YELLOW_LITERAL;
            }
        }
        return null;
    }

    private LinkColor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LinkColor[]{UNKNOWN_LITERAL, BLACK_LITERAL, DARK_BLUE_LITERAL, DARK_GRAY_LITERAL, BLUE_LITERAL, LIGHT_GRAY_LITERAL, RED_LITERAL, YELLOW_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

