/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LinkEndStyle implements Enumerator
{
    UNKNOWN_LITERAL(-1, "", ""),
    NO_ARROW_LITERAL(0, "without Symbol", "without Symbol"),
    OPEN_TRIANGLE_LITERAL(1, "open Triangle", "open Triangle"),
    EMPTY_TRIANGLE_LITERAL(2, "empty Triangle", "empty Triangle"),
    FILLED_TRIANGLE_LITERAL(3, "filled Triangle", "filled Triangle"),
    EMPTY_RHOMBUS_LITERAL(4, "empty Rhombus", "empty Rhombus"),
    FILLED_RHOMBUS_LITERAL(5, "filled Rhombus", "filled Rhombus");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int UNKNOWN = -1;
    public static final int NO_ARROW = 0;
    public static final int OPEN_TRIANGLE = 1;
    public static final int EMPTY_TRIANGLE = 2;
    public static final int FILLED_TRIANGLE = 3;
    public static final int EMPTY_RHOMBUS = 4;
    public static final int FILLED_RHOMBUS = 5;
    private static final LinkEndStyle[] VALUES_ARRAY;
    public static final List<LinkEndStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LinkEndStyle get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LinkEndStyle result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LinkEndStyle getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LinkEndStyle result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LinkEndStyle get(int value) {
        switch (value) {
            case -1: {
                return UNKNOWN_LITERAL;
            }
            case 0: {
                return NO_ARROW_LITERAL;
            }
            case 1: {
                return OPEN_TRIANGLE_LITERAL;
            }
            case 2: {
                return EMPTY_TRIANGLE_LITERAL;
            }
            case 3: {
                return FILLED_TRIANGLE_LITERAL;
            }
            case 4: {
                return EMPTY_RHOMBUS_LITERAL;
            }
            case 5: {
                return FILLED_RHOMBUS_LITERAL;
            }
        }
        return null;
    }

    private LinkEndStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LinkEndStyle[]{UNKNOWN_LITERAL, NO_ARROW_LITERAL, OPEN_TRIANGLE_LITERAL, EMPTY_TRIANGLE_LITERAL, FILLED_TRIANGLE_LITERAL, EMPTY_RHOMBUS_LITERAL, FILLED_RHOMBUS_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

