/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OrientationType implements Enumerator
{
    VERTICAL_LITERAL(0, "Vertical", "Vertical"),
    HORIZONTAL_LITERAL(1, "Horizontal", "Horizontal");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private static final OrientationType[] VALUES_ARRAY;
    public static final List<OrientationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static OrientationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            OrientationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static OrientationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            OrientationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static OrientationType get(int value) {
        switch (value) {
            case 0: {
                return VERTICAL_LITERAL;
            }
            case 1: {
                return HORIZONTAL_LITERAL;
            }
        }
        return null;
    }

    private OrientationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new OrientationType[]{VERTICAL_LITERAL, HORIZONTAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

