/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.IAttributeCategory;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.Model_Messages;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;

public class AttributeCategory
implements IAttributeCategory {
    private String id;
    private IAttributeCategory parent;
    private IExtensibleElement target;

    public AttributeCategory(IExtensibleElement target, String id, IAttributeCategory parent) {
        this.target = target;
        this.id = id;
        this.parent = parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getFullId() {
        return this.parent == null || this.parent.getFullId() == null ? this.id : this.parent.getFullId() + ":" + this.id;
    }

    @Override
    public List<AttributeType> getAttributes() {
        List attributes = CollectionUtils.newList();
        String prefix = this.getFullId();
        if (prefix != null) {
            prefix = prefix + ":";
        }
        for (AttributeType attribute : this.target.getAttribute()) {
            String name = attribute.getName();
            if ((prefix != null || name.indexOf(":") >= 0) && (name == null || !name.startsWith(prefix) || name.indexOf(58, prefix.length()) >= 0)) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    @Override
    public List<IAttributeCategory> getAttributeCategories() {
        List attributeCategories = CollectionUtils.newList();
        Set ids = CollectionUtils.newSet();
        String prefix = this.getFullId();
        if (prefix != null) {
            prefix = prefix + ":";
            for (AttributeType attribute : this.target.getAttribute()) {
                String[] categoryIds;
                String name = attribute.getName();
                if (name == null || !name.startsWith(prefix) || name.indexOf(58, prefix.length()) <= 0 || (categoryIds = name.substring(prefix.length()).split(":")).length <= 1 || ids.contains(categoryIds[0])) continue;
                ids.add(categoryIds[0]);
                attributeCategories.add(new AttributeCategory(this.target, categoryIds[0], this));
            }
        }
        return attributeCategories;
    }

    @Override
    public void removeAttribute(String attributeId) {
        List toRemove = CollectionUtils.newList();
        if (this.getFullId() != null) {
            String name = this.getFullId() + ":" + attributeId;
            for (AttributeType attribute : this.target.getAttribute()) {
                if (!attribute.getName().equals(name)) continue;
                toRemove.add(attribute);
            }
        }
        this.target.getAttribute().removeAll((Collection)toRemove);
    }

    @Override
    public void removeAttributeCategory(String categoryId) {
        List toRemove = CollectionUtils.newList();
        if (this.getFullId() != null) {
            String prefix = this.getFullId() + ":" + categoryId + ":";
            for (AttributeType attribute : this.target.getAttribute()) {
                if (!attribute.getName().startsWith(prefix)) continue;
                toRemove.add(attribute);
            }
        }
        this.target.getAttribute().removeAll((Collection)toRemove);
    }

    @Override
    public AttributeType getAttribute(String attributeId) {
        if (this.getFullId() != null) {
            return AttributeUtil.getAttribute(this.target, this.getFullId() + ":" + attributeId);
        }
        return null;
    }

    @Override
    public IAttributeCategory getAttributeCategory(String categoryId) {
        if (this.getFullId() != null) {
            String prefix = this.getFullId() + ":" + categoryId + ":";
            for (AttributeType attribute : this.target.getAttribute()) {
                if (!attribute.getName().startsWith(prefix)) continue;
                return new AttributeCategory(this.target, categoryId, this);
            }
        }
        return null;
    }

    @Override
    public AttributeType createAttribute(String attributeId) {
        if (this.getFullId() != null) {
            String attName = this.getFullId() + ":" + attributeId;
            if (AttributeUtil.getAttribute(this.target, attName) != null) {
                throw new IllegalArgumentException(MessageFormat.format(Model_Messages.MSG_ATTRIBUTE_EXISTS, attName));
            }
            AttributeType attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
            attribute.setName(attName);
            this.target.getAttribute().add((Object)attribute);
            return attribute;
        }
        return null;
    }

    @Override
    public IAttributeCategory createAttributeCategory(String categoryId) {
        if (this.getFullId() != null) {
            String prefix = this.getFullId() + ": " + categoryId;
            for (AttributeType attribute : this.target.getAttribute()) {
                if (!attribute.getName().startsWith(prefix)) continue;
                throw new IllegalArgumentException(MessageFormat.format(Model_Messages.MSG_ATTRIBUTE_CATEGORY_EXISTS, prefix));
            }
            return new AttributeCategory(this.target, categoryId, this);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeCategory)) {
            return false;
        }
        AttributeCategory attributeCategory = (AttributeCategory)o;
        if (this.id != null ? !this.id.equals(attributeCategory.id) : attributeCategory.id != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(attributeCategory.parent) : attributeCategory.parent != null) {
            return false;
        }
        return !(this.target != null ? !this.target.equals(attributeCategory.target) : attributeCategory.target != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 29 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }
}

