/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.impl;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;

public class IdentifiableReferenceImpl
extends EObjectImpl
implements IdentifiableReference {
    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    protected AttributeType attribute;
    protected EObject identifiable;
    private boolean changing;
    private Adapter adapter = new Adapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier().equals(IdentifiableReferenceImpl.this.attribute)) {
                if (CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value().equals(notification.getFeature()) && !IdentifiableReferenceImpl.this.changing) {
                    // empty if block
                }
            } else if (notification.getNotifier().equals(IdentifiableReferenceImpl.this.identifiable)) {
                if (CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id().equals(notification.getFeature()) || XpdlPackage.eINSTANCE.getTypeDeclarationType_Id().equals(notification.getFeature())) {
                    IdentifiableReferenceImpl.this.setValue(IdentifiableReferenceImpl.this.getId(IdentifiableReferenceImpl.this.identifiable));
                }
            } else {
                switch (notification.getEventType()) {
                    case 4: 
                    case 6: {
                        EObject extensible;
                        if (IdentifiableReferenceImpl.this.identifiable != notification.getOldValue() || IdentifiableReferenceImpl.this.identifiable.eContainer() != null) break;
                        ((EObject)notification.getNotifier()).eAdapters().remove((Object)this);
                        if (IdentifiableReferenceImpl.this.attribute == null || (extensible = IdentifiableReferenceImpl.this.attribute.eContainer()) == null || !(extensible instanceof IExtensibleElement)) break;
                        ((IExtensibleElement)extensible).getAttribute().remove((Object)IdentifiableReferenceImpl.this.attribute);
                    }
                }
            }
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    };

    protected IdentifiableReferenceImpl() {
    }

    protected EClass eStaticClass() {
        return CarnotWorkflowModelPackage.Literals.IDENTIFIABLE_REFERENCE;
    }

    @Override
    public AttributeType getAttribute() {
        return this.attribute;
    }

    public NotificationChain basicSetAttribute(AttributeType newAttribute, NotificationChain msgs) {
        if (this.attribute != null) {
            this.attribute.eAdapters().remove((Object)this.adapter);
        }
        AttributeType oldAttribute = this.attribute;
        this.attribute = newAttribute;
        if (this.identifiable != null && this.attribute != null) {
            this.attribute.setValue(this.getId(this.identifiable));
            this.attribute.eAdapters().add((Object)this.adapter);
        }
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldAttribute, (Object)newAttribute);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setAttribute(AttributeType newAttribute) {
        if (newAttribute != this.attribute) {
            NotificationChain msgs = null;
            if (this.attribute != null) {
                msgs = ((InternalEObject)this.attribute).eInverseRemove((InternalEObject)this, 7, AttributeType.class, msgs);
            }
            if (newAttribute != null) {
                msgs = ((InternalEObject)newAttribute).eInverseAdd((InternalEObject)this, 7, AttributeType.class, msgs);
            }
            if ((msgs = this.basicSetAttribute(newAttribute, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newAttribute, (Object)newAttribute));
        }
    }

    @Override
    public EObject getIdentifiable() {
        return this.identifiable;
    }

    @Override
    public void setIdentifiable(EObject newIdentifiable) {
        if (this.identifiable != null) {
            this.identifiable.eAdapters().remove((Object)this.adapter);
        }
        EObject oldIdentifiable = this.identifiable;
        this.identifiable = newIdentifiable;
        if (this.attribute != null) {
            String value = this.getId(this.identifiable);
            this.setValue(value);
        }
        if (newIdentifiable != null) {
            this.identifiable.eAdapters().add((Object)this.adapter);
            this.identifiable.eContainer().eAdapters().add((Object)this.adapter);
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldIdentifiable, (Object)this.identifiable));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                if (this.attribute != null) {
                    msgs = ((InternalEObject)this.attribute).eInverseRemove((InternalEObject)this, 7, AttributeType.class, msgs);
                }
                return this.basicSetAttribute((AttributeType)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetAttribute(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    private String getId(EObject identifiable) {
        String id = null;
        if (identifiable instanceof IIdentifiableElement) {
            id = ((IIdentifiableElement)identifiable).getId();
        } else if (identifiable instanceof TypeDeclarationType) {
            id = ((TypeDeclarationType)identifiable).getId();
        }
        ModelType thisModel = ModelUtils.findContainingModel(this.attribute);
        ModelType otherModel = ModelUtils.findContainingModel(identifiable);
        if (thisModel != otherModel) {
            String feature = identifiable.eContainingFeature().getName();
            id = feature + ":{" + otherModel.getId() + "}" + id;
        }
        return id;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAttribute();
            }
            case 1: {
                return this.getIdentifiable();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setAttribute((AttributeType)newValue);
                return;
            }
            case 1: {
                this.setIdentifiable((EObject)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setAttribute(null);
                return;
            }
            case 1: {
                this.setIdentifiable(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.attribute != null;
            }
            case 1: {
                return this.identifiable != null;
            }
        }
        return super.eIsSet(featureID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(String value) {
        this.changing = true;
        try {
            this.attribute.setValue(value);
        }
        finally {
            this.changing = false;
        }
    }
}

