/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.ExtensionsFactory;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.merge.LinkAttribute;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeAction;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.ModeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;

public class MergeUtils {
    public static Map<EObject, EObject> createClosureMap(List<EObject> closure, ModelType targetModel) {
        HashMap<EObject, EObject> map = new HashMap<EObject, EObject>();
        for (EObject element : closure) {
            if (element.eContainingFeature() == null) continue;
            EObject original = ModelUtils.findElementById((EObject)(element instanceof TypeDeclarationType ? targetModel.getTypeDeclarations() : targetModel), element.eContainingFeature(), MergeUtils.getId(element));
            map.put(element, original);
        }
        return map;
    }

    public static URI createQualifiedUri(URI uri, EObject eObject, boolean qualifyUri) {
        String id = MergeUtils.getId(eObject);
        return qualifyUri && id != null ? uri.appendSegment(eObject.eContainingFeature().getName()).appendSegment(id) : uri;
    }

    public static String getId(EObject eObject) {
        if (eObject instanceof IIdentifiableElement) {
            return ((IIdentifiableElement)eObject).getId();
        }
        if (eObject instanceof TypeDeclarationType) {
            return ((TypeDeclarationType)eObject).getId();
        }
        return null;
    }

    public static String getName(EObject eObject) {
        if (eObject instanceof IIdentifiableElement) {
            return ((IIdentifiableElement)eObject).getName();
        }
        if (eObject instanceof TypeDeclarationType) {
            return ((TypeDeclarationType)eObject).getName();
        }
        return null;
    }

    public static void deleteElement(EObject element, EObject parent) {
        EReference eFtrContainment = element.eContainmentFeature();
        if (eFtrContainment != null) {
            Object containment;
            if (parent == null) {
                parent = element.eContainer();
            }
            if ((containment = parent.eGet((EStructuralFeature)eFtrContainment)) instanceof List) {
                ((List)containment).remove(element);
            } else {
                parent.eUnset((EStructuralFeature)eFtrContainment);
            }
        }
    }

    public static void importElements(EObject eObject, ModelType targetModel, List<EObject> closure, Map<EObject, EObject> map, Map<EObject, MergeAction> reuseReplace, LinkAttribute linkAttribute) {
        EObject original;
        EObject element;
        EObject element2;
        IdentifiableReference ir;
        HashSet<ModelType> roots = new HashSet<ModelType>();
        roots.add(targetModel);
        for (int i = 0; i < closure.size(); ++i) {
            ModelType containingModel = ModelUtils.findContainingModel(closure.get(i));
            if (containingModel == null) continue;
            roots.add(containingModel);
        }
        Map refs = CollectionUtils.newMap();
        for (ModelType model : roots) {
            TreeIterator c = model.eAllContents();
            while (c.hasNext()) {
                EObject id;
                AttributeType att;
                EObject eo = (EObject)c.next();
                if (!(eo instanceof AttributeType) || (ir = (att = (AttributeType)eo).getReference()) == null || !closure.contains(id = ir.getIdentifiable())) continue;
                refs.put(ir, id);
                try {
                    ir.setIdentifiable(null);
                }
                catch (NullPointerException e) {}
            }
        }
        Map reuse = CollectionUtils.newMap();
        Map replace = CollectionUtils.newMap();
        List add = CollectionUtils.newList();
        for (int i = 0; i < closure.size(); ++i) {
            element2 = closure.get(i);
            EObject original2 = null;
            if (map != null) {
                original2 = map.get(element2);
            }
            if (original2 != null) {
                MergeAction actionId;
                MergeAction action = MergeAction.REPLACE;
                if (reuseReplace != null && (actionId = reuseReplace.get(original2)) != null) {
                    action = actionId;
                }
                if (action == MergeAction.REUSE) {
                    reuse.put(element2, original2);
                    continue;
                }
                if (action == MergeAction.REPLACE) {
                    replace.put(element2, original2);
                    continue;
                }
                return;
            }
            add.add(element2);
        }
        for (Map.Entry entry : reuse.entrySet()) {
            element = (EObject)entry.getKey();
            original = (EObject)entry.getValue();
            EStructuralFeature containingFeature = original.eContainingFeature();
            EObject eContainer = original.eContainer();
            List originalContainer = (List)eContainer.eGet(containingFeature);
            MergeUtils.replace(element, original);
            if (originalContainer.contains(original)) continue;
            originalContainer.add(original);
        }
        for (Map.Entry entry : replace.entrySet()) {
            element = (EObject)entry.getKey();
            original = (EObject)entry.getValue();
            if (linkAttribute != null) {
                linkAttribute.setLinkInfo(element, element != eObject);
            }
            MergeUtils.replace(original, element);
        }
        for (int i = 0; i < add.size(); ++i) {
            element2 = (EObject)add.get(i);
            if (linkAttribute != null) {
                linkAttribute.setLinkInfo(element2, element2 != eObject);
            }
            Object parent = null;
            parent = element2 instanceof TypeDeclarationType ? targetModel.getTypeDeclarations() : targetModel;
            Object ref = parent.eGet(element2.eContainingFeature());
            if (ref instanceof List) {
                ((List)ref).add(element2);
                continue;
            }
            parent.eSet(element2.eContainingFeature(), element2);
        }
        for (Map.Entry entry : refs.entrySet()) {
            ir = (IdentifiableReference)entry.getKey();
            EObject element3 = (EObject)entry.getValue();
            EObject original3 = (EObject)reuse.get(element3);
            try {
                ir.setIdentifiable(original3 == null ? element3 : original3);
            }
            catch (NullPointerException e) {}
        }
    }

    public static void replace(EObject object, EObject replacementObject, boolean preserveContainer) {
        if (preserveContainer) {
            EStructuralFeature containingFeature = replacementObject.eContainingFeature();
            EObject eContainer = replacementObject.eContainer();
            List originalContainer = (List)eContainer.eGet(containingFeature);
            MergeUtils.replace(object, replacementObject);
            if (!originalContainer.contains(replacementObject)) {
                originalContainer.add(replacementObject);
            }
        } else {
            MergeUtils.replace(object, replacementObject);
        }
    }

    public static void replace(EObject object, EObject replacementObject) {
        TreeIterator contents;
        EObject topContainer = object;
        while (topContainer.eContainer() != null) {
            topContainer = topContainer.eContainer();
        }
        if (!(replacementObject instanceof TypeDeclarationType)) {
            MergeUtils.replaceReferences(topContainer, object, replacementObject);
            contents = topContainer.eAllContents();
            while (contents.hasNext()) {
                MergeUtils.replaceReferences((EObject)contents.next(), object, replacementObject);
            }
        }
        try {
            EcoreUtil.replace((EObject)object, (EObject)replacementObject);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (replacementObject instanceof TypeDeclarationType) {
            MergeUtils.replaceReferences(topContainer, object, replacementObject);
            contents = topContainer.eAllContents();
            while (contents.hasNext()) {
                MergeUtils.replaceReferences((EObject)contents.next(), object, replacementObject);
            }
        }
        if (object instanceof ProcessDefinitionType) {
            MergeUtils.mergeFormalParameter((ProcessDefinitionType)object, (ProcessDefinitionType)replacementObject);
        }
    }

    private static void replaceReferences(EObject source, EObject object, EObject replacementObject) {
        AttributeType attribute;
        IdentifiableReference reference;
        EList crossReferences = source.eCrossReferences();
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)crossReferences.iterator();
        List objects = CollectionUtils.newList();
        List references = CollectionUtils.newList();
        while (featureIterator.hasNext()) {
            objects.add(featureIterator.next());
            references.add((EReference)featureIterator.feature());
        }
        if (!objects.contains(replacementObject)) {
            for (int i = 0; i < objects.size(); ++i) {
                List list;
                int index;
                Object target = objects.get(i);
                EReference feature = (EReference)references.get(i);
                if (target == object) {
                    EcoreUtil.replace((EObject)source, (EStructuralFeature)feature, (Object)object, (Object)replacementObject);
                    continue;
                }
                if (!(target instanceof List) || (index = (list = (List)target).indexOf(object)) < 0) continue;
                EcoreUtil.replace((EObject)source, (EStructuralFeature)feature, (Object)object, (Object)replacementObject);
            }
        }
        if (source instanceof AttributeType && (reference = (attribute = (AttributeType)source).getReference()) != null && object == reference.getIdentifiable()) {
            reference.setIdentifiable(replacementObject);
        }
    }

    public static void mergeFormalParameter(ProcessDefinitionType source, ProcessDefinitionType target) {
        FormalParameterMappingsType parameterMappings = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        FormalParametersType formalParameters = XpdlFactory.eINSTANCE.createFormalParametersType();
        FormalParameterMappingsType formalParameterMappings = source.getFormalParameterMappings();
        FormalParametersType referencedParametersType = source.getFormalParameters();
        if (referencedParametersType == null) {
            return;
        }
        for (FormalParameterType referencedParameterType : referencedParametersType.getFormalParameter()) {
            ModeType mode = referencedParameterType.getMode();
            DataType mappedData = formalParameterMappings.getMappedData(referencedParameterType);
            IIdentifiableModelElement modelElement = (IIdentifiableModelElement)MergeUtils.getSameModelElement(mappedData, (ModelType)target.eContainer(), null);
            FormalParameterType parameterType = ModelUtils.cloneFormalParameterType(referencedParameterType, mappedData);
            parameterType.setMode(mode);
            formalParameters.addFormalParameter(parameterType);
            parameterMappings.setMappedData(parameterType, (DataType)modelElement);
        }
        target.setFormalParameters(formalParameters);
        target.setFormalParameterMappings(parameterMappings);
    }

    public static EObject getSameModelElement(EObject source, ModelType target, Map changedCache) {
        Stack<EObject> stack = new Stack<EObject>();
        if (source instanceof ModelType) {
            return target;
        }
        if (source instanceof TypeDeclarationsType) {
            return target.getTypeDeclarations();
        }
        if (source instanceof TypeDeclarationType) {
            TypeDeclarationsType declarations = target.getTypeDeclarations();
            TypeDeclarationType typeDeclaration = declarations.getTypeDeclaration(((TypeDeclarationType)source).getId());
            return typeDeclaration;
        }
        EObject parent = source.eContainer();
        boolean getParent = false;
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModelType) && parent.eContainer() != null) {
            if (getParent) {
                EObject checkParent;
                parent = parent.eContainer();
                if (changedCache != null && (checkParent = (EObject)changedCache.get(parent)) != null) {
                    parent = checkParent;
                }
            }
            if (!(parent instanceof ModelType)) {
                stack.push(parent);
            }
            getParent = true;
        }
        if (stack.isEmpty()) {
            return MergeUtils.getSameElement(source, target);
        }
        ModelType targetObject = target;
        while (!stack.isEmpty()) {
            EObject child = (EObject)stack.pop();
            parent = MergeUtils.getSameElement(child, targetObject);
            if (parent == null) {
                return null;
            }
            targetObject = parent;
        }
        return MergeUtils.getSameElement(source, targetObject);
    }

    public static EObject getSameElement(EObject source, EObject model) {
        EObject entry;
        int i;
        Object element;
        if (source instanceof ModelType && model instanceof ModelType) {
            return model;
        }
        String sourceUuid = UUIDUtils.getUUID(source);
        EStructuralFeature feature = source.eContainingFeature();
        if (feature == null) {
            return null;
        }
        if (source instanceof TypeDeclarationType) {
            ModelType theModel = ModelUtils.findContainingModel(model);
            element = theModel.getTypeDeclarations().eGet(feature);
        } else {
            element = model.eGet(feature);
        }
        List list = new ArrayList();
        if (element == null) {
            return null;
        }
        if (!(element instanceof List)) {
            return null;
        }
        list = (List)element;
        for (i = 0; i < list.size(); ++i) {
            entry = (EObject)list.get(i);
            String uuid = UUIDUtils.getUUID(entry);
            if (StringUtils.isEmpty((String)uuid) || StringUtils.isEmpty((String)sourceUuid) || !uuid.equals(sourceUuid)) continue;
            return entry;
        }
        for (i = 0; i < list.size(); ++i) {
            entry = (EObject)list.get(i);
            if (entry instanceof IIdentifiableElement && source instanceof IIdentifiableElement && ((IIdentifiableElement)entry).getId() != null && ((IIdentifiableElement)source).getId() != null) {
                if (!((IIdentifiableElement)entry).getId().equals(((IIdentifiableElement)source).getId())) continue;
                return entry;
            }
            if (entry instanceof DiagramType && source instanceof DiagramType) {
                String entryName = ((DiagramType)entry).getName();
                String sourceName = ((DiagramType)source).getName();
                if (entryName == null && sourceName == null) {
                    return entry;
                }
                if (entryName == null || sourceName == null || !((DiagramType)entry).getName().equals(((DiagramType)source).getName())) continue;
                return entry;
            }
            if (!(entry instanceof IModelElement && source instanceof IModelElement ? ((IModelElement)entry).getElementOid() == ((IModelElement)source).getElementOid() : entry instanceof TypeDeclarationType && source instanceof TypeDeclarationType && ((TypeDeclarationType)entry).getId().equals(((TypeDeclarationType)source).getId()))) continue;
            return entry;
        }
        return null;
    }

    public static void fixDuplicateOids(ModelType model) {
        long highestOid = ModelUtils.getMaxUsedOid(model);
        HashSet<Long> oids = new HashSet<Long>();
        if (model.isSetOid()) {
            oids.add(model.getOid());
        }
        TreeIterator i = model.eAllContents();
        while (i.hasNext()) {
            EObject obj = (EObject)i.next();
            if (!(obj instanceof IModelElement) || !((IModelElement)obj).isSetElementOid()) continue;
            long elementOid = ((IModelElement)obj).getElementOid();
            if (oids.contains(elementOid)) {
                ((IModelElement)obj).setElementOid(highestOid++);
                continue;
            }
            oids.add(((IModelElement)obj).getElementOid());
        }
    }
}

