/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.IAttributeCategory;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.impl.AttributeCategory;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class AttributeUtil {
    public static AttributeType getAttribute(IExtensibleElement element, String att) {
        EList<AttributeType> attributes = element.getAttribute();
        return AttributeUtil.getAttribute(attributes, att);
    }

    private static AttributeType getAttribute(List<AttributeType> attributes, String att) {
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeType attribute = attributes.get(i);
            if (attribute.getName() == null || !attribute.getName().equals(att)) continue;
            return attribute;
        }
        return null;
    }

    public static boolean getBooleanValue(IExtensibleElement element, String att) {
        return AttributeUtil.getBooleanValue(AttributeUtil.getAttribute(element, att));
    }

    public static boolean getBooleanValue(AttributeType attribute) {
        return null != attribute && Type.Boolean.getId().equals(attribute.getType()) && Boolean.TRUE.toString().equals(attribute.getValue());
    }

    public static String getAttributeValue(IExtensibleElement element, String nameAtt) {
        AttributeType attribute = AttributeUtil.getAttribute(element, nameAtt);
        return attribute == null ? null : attribute.getValue();
    }

    public static String getAttributeValue(List<AttributeType> attributes, String nameAtt) {
        AttributeType attribute = AttributeUtil.getAttribute(attributes, nameAtt);
        return attribute == null ? null : attribute.getValue();
    }

    public static AttributeType setAttribute(IExtensibleElement element, String name, String value) {
        return AttributeUtil.setAttribute(element.getAttribute(), name, null, value);
    }

    public static AttributeType setAttribute(IExtensibleElement element, String name, String type, String value) {
        return AttributeUtil.setAttribute(element.getAttribute(), name, type, value);
    }

    public static AttributeType setAttribute(List<AttributeType> list, String name, String value) {
        return AttributeUtil.setAttribute(list, name, null, value);
    }

    public static AttributeType setAttribute(List<AttributeType> list, String name, String type, String value) {
        AttributeType attribute = null;
        for (int i = 0; i < list.size(); ++i) {
            AttributeType attr = list.get(i);
            if (!name.equals(attr.getName())) continue;
            if (null != value && 0 < value.length()) {
                attribute = attr;
                break;
            }
            list.remove(i);
            break;
        }
        if (null != value && 0 < value.length()) {
            if (null == attribute) {
                attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
                attribute.setName(name);
            }
            boolean deliver = attribute.eDeliver();
            attribute.eSetDeliver(false);
            attribute.setType(type);
            attribute.eSetDeliver(deliver);
            if (!AttributeUtil.areEqual(value, attribute.getValue())) {
                attribute.setValue(value);
            }
            if (!list.contains(attribute)) {
                list.add(attribute);
            }
        }
        return attribute;
    }

    private static boolean areEqual(Object value1, Object value2) {
        return value1 == value2 || value1 != null && value1.equals(value2);
    }

    public static void setBooleanAttribute(IExtensibleElement element, String name, Boolean value) {
        AttributeUtil.setAttribute(element, name, "boolean", value == null ? null : (value != false ? "true" : "false"));
    }

    public static void clearExcept(IExtensibleElement element, String[] ids) {
        Iterator i = element.getAttribute().iterator();
        while (i.hasNext()) {
            AttributeType attribute = (AttributeType)i.next();
            boolean found = false;
            for (int j = 0; j < ids.length; ++j) {
                if (!attribute.getName().equals(ids[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            i.remove();
        }
    }

    public static List<IAttributeCategory> getAttributeCategories(IExtensibleElement element) {
        List categories = CollectionUtils.newList();
        for (AttributeType attribute : element.getAttribute()) {
            String categoryID = AttributeUtil.getCategoryName(attribute.getName());
            IAttributeCategory category = AttributeUtil.getExistingCategory(categoryID, categories);
            if (category != null) continue;
            category = new AttributeCategory(element, categoryID, null);
            categories.add(category);
        }
        return categories;
    }

    private static String getCategoryName(String attName) {
        if (attName.indexOf(":") < 0) {
            return null;
        }
        String[] categoryIDs = attName.split(":");
        return categoryIDs[0];
    }

    private static IAttributeCategory getExistingCategory(String id, List<IAttributeCategory> categories) {
        for (IAttributeCategory category : categories) {
            if ((id != null || category.getId() != null) && (id == null || !id.equals(category.getId()))) continue;
            return category;
        }
        return null;
    }

    public static IAttributeCategory createAttributeCategory(IExtensibleElement element, String id) {
        return new AttributeCategory(element, id, null);
    }

    public static <T extends EObject> T getIdentifiable(IExtensibleElement element, String name) {
        IdentifiableReference reference;
        AttributeType attribute = AttributeUtil.getAttribute(element, name);
        if (attribute != null && (reference = attribute.getReference()) != null) {
            EObject result = reference.getIdentifiable();
            return (T)result;
        }
        return null;
    }

    public static AttributeType createAttribute(String name) {
        AttributeType attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
        attribute.setName(name);
        return attribute;
    }

    public static void setReference(IExtensibleElement element, String name, EObject identifiable) {
        AttributeType attribute = AttributeUtil.getAttribute(element, name);
        if (identifiable == null) {
            if (attribute != null) {
                element.getAttribute().remove((Object)attribute);
            }
        } else {
            if (attribute == null) {
                attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
                attribute.setName(name);
                element.getAttribute().add((Object)attribute);
            }
            AttributeUtil.setReference(attribute, identifiable);
        }
    }

    public static void setReference(AttributeType attribute, EObject element) {
        IdentifiableReference reference = attribute.getReference();
        if (reference == null || reference.getAttribute() != attribute) {
            reference = CarnotWorkflowModelFactory.eINSTANCE.createIdentifiableReference();
            attribute.setReference(reference);
        }
        reference.setIdentifiable(element);
    }

    public static EObject getReferenceElement(AttributeType attribute) {
        IdentifiableReference ref = attribute.getReference();
        if (ref != null) {
            return ref.getIdentifiable();
        }
        return null;
    }

    public static boolean isReference(AttributeType attribute) {
        return attribute.getReference() != null;
    }

    public static boolean isReference(IExtensibleElement element, String feature) {
        List<IConfigurationElement> configs = SpiExtensionRegistry.getConfiguration(element, "elementReference");
        if (configs != null) {
            for (IConfigurationElement config : configs) {
                IConfigurationElement[] refs = config.getChildren("attribute");
                for (int k = 0; k < refs.length; ++k) {
                    if (!feature.equals(refs[k].getAttribute("attributeName"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getCDataAttribute(IExtensibleElement data, String name) {
        XmlTextNode node;
        String xmlString = null;
        AttributeType attr = AttributeUtil.getAttribute(data, name);
        if (attr != null && (node = attr.getValueNode()) != null) {
            xmlString = ModelUtils.getCDataString(node.getMixed());
        }
        return xmlString;
    }

    public static void setCDataAttribute(IExtensibleElement data, String name, String value) {
        if (value == null) {
            AttributeUtil.setAttribute(data, name, value);
        } else {
            XmlTextNode node;
            AttributeType attr = AttributeUtil.getAttribute(data, name);
            if (attr == null) {
                attr = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
                attr.setName(name);
                data.getAttribute().add((Object)attr);
            }
            if ((node = attr.getValueNode()) == null) {
                node = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
                attr.setValueNode(node);
            }
            ModelUtils.setCDataString(node.getMixed(), value);
        }
    }
}

