/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MIFlowConditionType implements Enumerator
{
    NONE(0, "None", "None"),
    ONE(1, "One", "One"),
    ALL(2, "All", "All"),
    COMPLEX(3, "Complex", "Complex");

    public static final String copyright = "Copyright 2008 by SunGard";
    public static final int NONE_VALUE = 0;
    public static final int ONE_VALUE = 1;
    public static final int ALL_VALUE = 2;
    public static final int COMPLEX_VALUE = 3;
    private static final MIFlowConditionType[] VALUES_ARRAY;
    public static final List<MIFlowConditionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static MIFlowConditionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MIFlowConditionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static MIFlowConditionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MIFlowConditionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static MIFlowConditionType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return ALL;
            }
            case 3: {
                return COMPLEX;
            }
        }
        return null;
    }

    private MIFlowConditionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new MIFlowConditionType[]{NONE, ONE, ALL, COMPLEX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

