/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModeType implements Enumerator
{
    IN(0, "IN", "IN"),
    OUT(1, "OUT", "OUT"),
    INOUT(2, "INOUT", "INOUT");

    public static final String copyright = "Copyright 2008 by SunGard";
    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    private static final ModeType[] VALUES_ARRAY;
    public static final List<ModeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ModeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ModeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ModeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ModeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ModeType get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
        }
        return null;
    }

    private ModeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ModeType[]{IN, OUT, INOUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

