/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TypeType implements Enumerator
{
    STRING(0, "STRING", "STRING"),
    FLOAT(1, "FLOAT", "FLOAT"),
    INTEGER(2, "INTEGER", "INTEGER"),
    REFERENCE(3, "REFERENCE", "REFERENCE"),
    DATETIME(4, "DATETIME", "DATETIME"),
    BOOLEAN(5, "BOOLEAN", "BOOLEAN"),
    PERFORMER(6, "PERFORMER", "PERFORMER");

    public static final String copyright = "Copyright 2008 by SunGard";
    public static final int STRING_VALUE = 0;
    public static final int FLOAT_VALUE = 1;
    public static final int INTEGER_VALUE = 2;
    public static final int REFERENCE_VALUE = 3;
    public static final int DATETIME_VALUE = 4;
    public static final int BOOLEAN_VALUE = 5;
    public static final int PERFORMER_VALUE = 6;
    private static final TypeType[] VALUES_ARRAY;
    public static final List<TypeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static TypeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            TypeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static TypeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            TypeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static TypeType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return FLOAT;
            }
            case 2: {
                return INTEGER;
            }
            case 3: {
                return REFERENCE;
            }
            case 4: {
                return DATETIME;
            }
            case 5: {
                return BOOLEAN;
            }
            case 6: {
                return PERFORMER;
            }
        }
        return null;
    }

    private TypeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new TypeType[]{STRING, FLOAT, INTEGER, REFERENCE, DATETIME, BOOLEAN, PERFORMER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

