/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;

public class ExtendedAttributeUtil {
    public static ExtendedAttributeType getAttribute(Extensible decl, String name) {
        return decl == null ? null : ExtendedAttributeUtil.getAttribute(decl.getExtendedAttributes(), name);
    }

    public static ExtendedAttributeType getAttribute(ExtendedAttributesType attributes, String name) {
        if (attributes != null) {
            for (ExtendedAttributeType attribute : attributes.getExtendedAttribute()) {
                if (!attribute.getName().equals(name)) continue;
                return attribute;
            }
        }
        return null;
    }

    public static boolean getBooleanValue(Extensible decl, String name) {
        return decl == null ? false : ExtendedAttributeUtil.getBooleanValue(decl.getExtendedAttributes(), name);
    }

    public static boolean getBooleanValue(ExtendedAttributesType attributes, String name) {
        return attributes == null ? false : ExtendedAttributeUtil.getBooleanValue(ExtendedAttributeUtil.getAttribute(attributes, name));
    }

    public static boolean getBooleanValue(ExtendedAttributeType attribute) {
        return null != attribute && Boolean.TRUE.toString().equals(attribute.getValue());
    }

    public static String getAttributeValue(Extensible decl, String name) {
        ExtendedAttributeType attribute = ExtendedAttributeUtil.getAttribute(decl, name);
        return attribute == null ? null : attribute.getValue();
    }

    public static String getAttributeValue(ExtendedAttributesType attributes, String name) {
        ExtendedAttributeType attribute = ExtendedAttributeUtil.getAttribute(attributes, name);
        return attribute == null ? null : attribute.getValue();
    }

    public static ExtendedAttributeType setAttribute(Extensible decl, String name, String value) {
        if (decl == null) {
            return null;
        }
        ExtendedAttributesType attributes = decl.getExtendedAttributes();
        if (attributes == null) {
            attributes = XpdlFactory.eINSTANCE.createExtendedAttributesType();
            decl.setExtendedAttributes(attributes);
        }
        return ExtendedAttributeUtil.setAttribute(attributes, name, value);
    }

    public static ExtendedAttributeType setAttribute(ExtendedAttributesType attributes, String name, String value) {
        ExtendedAttributeType attribute = null;
        if (attributes != null) {
            EList<ExtendedAttributeType> list = attributes.getExtendedAttribute();
            for (int i = 0; i < list.size(); ++i) {
                ExtendedAttributeType attr = (ExtendedAttributeType)list.get(i);
                if (!name.equals(attr.getName())) continue;
                if (null != value && 0 < value.length()) {
                    attribute = attr;
                    break;
                }
                list.remove(i);
                break;
            }
            if (!StringUtils.isEmpty((String)value)) {
                if (null == attribute) {
                    attribute = XpdlFactory.eINSTANCE.createExtendedAttributeType();
                    attribute.setName(name);
                    attribute.setValue(value);
                    list.add(attribute);
                } else if (!CompareHelper.areEqual((Object)value, (Object)attribute.getValue())) {
                    attribute.setValue(value);
                }
            }
        }
        return attribute;
    }

    public static void setBooleanAttribute(Extensible decl, String name, boolean value) {
        ExtendedAttributeUtil.setAttribute(decl, name, Boolean.toString(value));
    }

    public static void setBooleanAttribute(ExtendedAttributesType attributes, String name, boolean value) {
        ExtendedAttributeUtil.setAttribute(attributes, name, Boolean.toString(value));
    }

    public static ExtendedAttributeType createAttribute(Extensible decl, String name) {
        ExtendedAttributesType attributes = decl.getExtendedAttributes();
        if (attributes == null) {
            attributes = XpdlFactory.eINSTANCE.createExtendedAttributesType();
            decl.setExtendedAttributes(attributes);
        }
        ExtendedAttributeType attribute = XpdlFactory.eINSTANCE.createExtendedAttributeType();
        attribute.setName(name);
        attributes.getExtendedAttribute().add((Object)attribute);
        return attribute;
    }
}

