/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DirectionType implements Enumerator
{
    IN_LITERAL(1, "IN", "IN"),
    OUT_LITERAL(2, "OUT", "OUT"),
    INOUT_LITERAL(3, "INOUT", "INOUT");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int INOUT = 3;
    private static final DirectionType[] VALUES_ARRAY;
    public static final List<DirectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DirectionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DirectionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DirectionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DirectionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DirectionType get(int value) {
        switch (value) {
            case 1: {
                return IN_LITERAL;
            }
            case 2: {
                return OUT_LITERAL;
            }
            case 3: {
                return INOUT_LITERAL;
            }
        }
        return null;
    }

    private DirectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DirectionType[]{IN_LITERAL, OUT_LITERAL, INOUT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

