/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LoopType implements Enumerator
{
    UNKNOWN_LITERAL(0, "Unknown", "Unknown"),
    NONE_LITERAL(1, "No Loop", "No Loop"),
    WHILE_LITERAL(2, "While", "While"),
    REPEAT_LITERAL(3, "Repeat", "Repeat");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int UNKNOWN = 0;
    public static final int NONE = 1;
    public static final int WHILE = 2;
    public static final int REPEAT = 3;
    private static final LoopType[] VALUES_ARRAY;
    public static final List<LoopType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LoopType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LoopType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LoopType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LoopType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LoopType get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN_LITERAL;
            }
            case 1: {
                return NONE_LITERAL;
            }
            case 2: {
                return WHILE_LITERAL;
            }
            case 3: {
                return REPEAT_LITERAL;
            }
        }
        return null;
    }

    private LoopType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LoopType[]{UNKNOWN_LITERAL, NONE_LITERAL, WHILE_LITERAL, REPEAT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

