/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RoutingType implements Enumerator
{
    DEFAULT_LITERAL(0, "Default", "Default"),
    SHORTEST_PATH_LITERAL(1, "ShortestPath", "ShortestPath"),
    MANHATTAN_LITERAL(2, "Manhattan", "Manhattan"),
    EXPLICIT_LITERAL(3, "Explicit", "Explicit");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int DEFAULT = 0;
    public static final int SHORTEST_PATH = 1;
    public static final int MANHATTAN = 2;
    public static final int EXPLICIT = 3;
    private static final RoutingType[] VALUES_ARRAY;
    public static final List<RoutingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static RoutingType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            RoutingType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static RoutingType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            RoutingType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static RoutingType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT_LITERAL;
            }
            case 1: {
                return SHORTEST_PATH_LITERAL;
            }
            case 2: {
                return MANHATTAN_LITERAL;
            }
            case 3: {
                return EXPLICIT_LITERAL;
            }
        }
        return null;
    }

    private RoutingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new RoutingType[]{DEFAULT_LITERAL, SHORTEST_PATH_LITERAL, MANHATTAN_LITERAL, EXPLICIT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

