/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IAccessPointOwner;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;

public class AccessPointUtil {
    public static boolean isDirectionCompatible(AccessPointType ap, boolean isIn) {
        DirectionType dir = ap.getDirection();
        return dir == null ? false : (isIn ? AccessPointUtil.isIn(dir) : AccessPointUtil.isOut(dir));
    }

    public static boolean isBrowsable(AccessPointType ap) {
        return AttributeUtil.getBooleanValue(ap, "carnot:engine:browsable");
    }

    public static AccessPointType createIntrinsicAccessPoint(String id, String name, String className, DirectionType direction, boolean browsable, String[] characteristics, DataTypeType type) {
        AccessPointType result = AccessPointUtil.createAccessPoint(id, name, direction, type);
        if (className != null) {
            String typeAtt = "serializable".equals(type.getId()) ? "carnot:engine:className" : ("entity".equals(type.getId()) ? "carnot:engine:remoteInterface" : "carnot:engine:type");
            AttributeUtil.setAttribute(result, typeAtt, className);
        }
        if (characteristics != null && characteristics.length > 0) {
            AttributeUtil.setAttribute(result, "carnot:engine:flavor", characteristics[1], characteristics[0]);
        }
        AttributeUtil.setAttribute(result, "carnot:engine:browsable", "boolean", (browsable ? Boolean.TRUE : Boolean.FALSE).toString());
        return result;
    }

    public static AccessPointType createAccessPoint(FormalParameterType parameter, DataType data) {
        DirectionType direction;
        switch (parameter.getMode()) {
            case IN: {
                direction = DirectionType.IN_LITERAL;
                break;
            }
            case OUT: {
                direction = DirectionType.OUT_LITERAL;
                break;
            }
            case INOUT: {
                direction = DirectionType.INOUT_LITERAL;
                break;
            }
            default: {
                direction = null;
            }
        }
        AccessPointType ap = AccessPointUtil.createAccessPoint(parameter.getId(), parameter.getName(), direction, data.getType());
        EList attributes = ap.getAttribute();
        for (AttributeType attribute : data.getAttribute()) {
            attributes.add((AttributeType)EcoreUtil.copy((EObject)attribute));
        }
        return ap;
    }

    public static AccessPointType createAccessPoint(String id, String name, DirectionType direction, DataTypeType type) {
        AccessPointType result = CarnotWorkflowModelFactory.eINSTANCE.createAccessPointType();
        result.setId(id);
        result.setName(name);
        result.setType(type);
        result.setDirection(direction);
        return result;
    }

    public static boolean isIn(DirectionType direction) {
        return DirectionType.IN_LITERAL.equals((Object)direction) || DirectionType.INOUT_LITERAL.equals((Object)direction) || direction == null;
    }

    public static boolean isOut(DirectionType direction) {
        return DirectionType.OUT_LITERAL.equals((Object)direction) || DirectionType.INOUT_LITERAL.equals((Object)direction) || direction == null;
    }

    public static List<AccessPointType> getInAccessPonts(IAccessPointOwner scope) {
        List result = null;
        if (null != scope) {
            EList<AccessPointType> aps = scope.getAccessPoint();
            for (AccessPointType ap : aps) {
                if (!AccessPointUtil.isIn(ap.getDirection())) continue;
                if (null == result) {
                    result = CollectionUtils.newList((int)aps.size());
                }
                result.add(ap);
            }
        }
        return null == result ? Collections.emptyList() : result;
    }

    public static List<AccessPointType> getOutAccessPonts(IAccessPointOwner scope) {
        List result = null;
        if (null != scope) {
            EList<AccessPointType> aps = scope.getAccessPoint();
            for (AccessPointType ap : aps) {
                if (!AccessPointUtil.isOut(ap.getDirection())) continue;
                if (null == result) {
                    result = CollectionUtils.newList((int)aps.size());
                }
                result.add(ap);
            }
        }
        return null == result ? Collections.emptyList() : result;
    }

    public static void removeAccessPoints(List<? extends AccessPointType> list, boolean isIn) {
        for (int i = list.size() - 1; i >= 0; --i) {
            AccessPointType ap = list.get(i);
            if (!AccessPointUtil.isDirectionCompatible(ap, isIn)) continue;
            list.remove(i);
        }
    }

    public static IAccessPathEditor getSPIAccessPathEditor(DataTypeType type) {
        Map<String, IConfigurationElement> dataTypes = SpiExtensionRegistry.instance().getExtensions("dataTypes");
        IConfigurationElement config = dataTypes.get(type.getId());
        if (config != null) {
            try {
                return (IAccessPathEditor)config.createExecutableExtension("accessPathEditorClass");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getTypeAttributeValue(AccessPointType accessPoint) {
        String attrValue = AttributeUtil.getAttributeValue(accessPoint, "carnot:engine:className");
        if (attrValue == null) {
            attrValue = AttributeUtil.getAttributeValue(accessPoint, "carnot:engine:type");
        }
        if (attrValue == null) {
            attrValue = AttributeUtil.getAttributeValue(accessPoint, "carnot:engine:remoteInterface");
        }
        return attrValue;
    }

    public static AccessPointType findAccessPoint(EList<AccessPointType> accessPoints, String id, DirectionType direction) {
        AccessPointType accessPoint = null;
        for (AccessPointType ap : accessPoints) {
            if (!id.equals(ap.getId()) || !direction.equals((Object)ap.getDirection())) continue;
            return ap;
        }
        return accessPoint;
    }
}

