/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventConditionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.UnbindActionType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;

public class ActionTypeUtil {
    public static EventActionTypeType getActionType(IModelElement element) {
        if (element instanceof EventActionType) {
            return ((EventActionType)element).getType();
        }
        if (element instanceof BindActionType) {
            return ((BindActionType)element).getType();
        }
        if (element instanceof UnbindActionType) {
            return ((UnbindActionType)element).getType();
        }
        return null;
    }

    public static String getContext(IModelElement element) {
        if (element instanceof EventActionType) {
            return "event";
        }
        if (element instanceof BindActionType) {
            return "bind";
        }
        if (element instanceof UnbindActionType) {
            return "unbind";
        }
        return "";
    }

    private static boolean isSupported(ImplementationType implementation, IConfigurationElement type, String context) {
        if (!implementation.equals((Object)ImplementationType.PULL_LITERAL) && (context.equals("bind") || context.equals("unbind"))) {
            return false;
        }
        String unsupportedContexts = type.getAttribute("unsupportedContexts");
        StringTokenizer st = new StringTokenizer(unsupportedContexts == null ? "" : unsupportedContexts, ",");
        while (st.hasMoreTokens()) {
            if (!context.equalsIgnoreCase(st.nextToken().trim())) continue;
            return false;
        }
        return true;
    }

    public static List getSupportedActionTypes(EventConditionTypeType condition, boolean process, boolean activity, String context) {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        List<IConfigurationElement> actionTypes = SpiExtensionRegistry.instance().getExtensionList("actionTypes");
        for (int i = 0; i < actionTypes.size(); ++i) {
            IConfigurationElement action = actionTypes.get(i);
            if (!ActionTypeUtil.matchParent(action, process, activity)) continue;
            String supportedConditions = action.getAttribute("supportedConditionTypes");
            StringTokenizer st = new StringTokenizer(supportedConditions == null ? "" : supportedConditions, ",");
            while (st.hasMoreTokens()) {
                if (!condition.getId().equalsIgnoreCase(st.nextToken().trim()) || context != null && !ActionTypeUtil.isSupported(condition.getImplementation(), action, context)) continue;
                list.add(action);
            }
        }
        return list;
    }

    public static IConfigurationElement findFirstActionType(EventHandlerType handler, String context) {
        boolean isProcess = handler.eContainer() instanceof ProcessDefinitionType;
        boolean isActivity = handler.eContainer() instanceof ActivityType;
        EventConditionTypeType condition = handler.getType();
        List<IConfigurationElement> actionTypes = SpiExtensionRegistry.instance().getExtensionList("actionTypes");
        for (int i = 0; i < actionTypes.size(); ++i) {
            IConfigurationElement action = actionTypes.get(i);
            if (!ActionTypeUtil.matchParent(action, isProcess, isActivity)) continue;
            String supportedConditions = action.getAttribute("supportedConditionTypes");
            StringTokenizer st = new StringTokenizer(supportedConditions == null ? "" : supportedConditions, ",");
            while (st.hasMoreTokens()) {
                if (!condition.getId().equalsIgnoreCase(st.nextToken().trim()) || !ActionTypeUtil.isSupported(condition.getImplementation(), action, context)) continue;
                return action;
            }
        }
        return null;
    }

    private static boolean matchParent(IConfigurationElement action, boolean process, boolean activity) {
        return activity && ActionTypeUtil.getBoolean(action, "activityAction") || process && ActionTypeUtil.getBoolean(action, "processAction");
    }

    private static boolean getBoolean(IConfigurationElement action, String attName) {
        return "true".equalsIgnoreCase(action.getAttribute(attName));
    }

    public static boolean isAction(Object selection) {
        return selection instanceof AbstractEventAction;
    }

    public static List getSupportedActionTypes(EventHandlerType handler, String context) {
        boolean process = handler.eContainer() instanceof ProcessDefinitionType;
        boolean activity = handler.eContainer() instanceof ActivityType;
        EventConditionTypeType type = handler.getType();
        return ActionTypeUtil.getSupportedActionTypes(type, process, activity, context);
    }

    public static Object getActionTypeConfigurationElement(IIdentifiableModelElement eventActionType) {
        EventActionTypeType type = ActionTypeUtil.getActionType(eventActionType);
        return SpiExtensionRegistry.instance().getExtensions("actionTypes").get(type.getId());
    }
}

