/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPointProvider;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.ModeType;

public class ActivityUtil {
    public static boolean isInteractive(ActivityType activity) {
        return ActivityUtil.isInteractive(activity, activity.getImplementation());
    }

    public static boolean isInteractive(ActivityType activity, ActivityImplementationType implementation) {
        ApplicationType application;
        if (ActivityImplementationType.MANUAL_LITERAL.equals((Object)implementation)) {
            return true;
        }
        if (ActivityImplementationType.APPLICATION_LITERAL.equals((Object)implementation) && (application = activity.getApplication()) != null) {
            return application.isInteractive();
        }
        return false;
    }

    public static boolean isSubprocessActivity(ActivityType activity) {
        return ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)activity.getImplementation());
    }

    public static boolean isRouteActivity(ActivityType activity) {
        return ActivityImplementationType.ROUTE_LITERAL.equals((Object)activity.getImplementation());
    }

    public static boolean isApplicationActivity(ActivityType activity) {
        return ActivityImplementationType.APPLICATION_LITERAL.equals((Object)activity.getImplementation());
    }

    public static List<ApplicationContextTypeType> getContextTypes(ActivityType activity, DirectionType direction) {
        return ActivityUtil.getContextTypes(activity, activity.getImplementation(), direction);
    }

    public static List<ApplicationContextTypeType> getContextTypes(ActivityType activity, ActivityImplementationType implementation, DirectionType direction) {
        ApplicationType application;
        List contexts = CollectionUtils.newList();
        ModelType model = ModelUtils.findContainingModel(activity);
        if (ActivityUtil.isRouteActivity(activity) || ActivityUtil.isInteractive(activity, implementation)) {
            ActivityUtil.addContext("default", model, contexts);
        }
        if (!(ActivityUtil.isRouteActivity(activity) && DirectionType.IN_LITERAL.equals((Object)direction) || ActivityUtil.isSubprocessActivity(activity) && !ActivityUtil.isDataMappingEnabled(activity, DirectionType.IN_LITERAL.equals((Object)direction)))) {
            ActivityUtil.addContext("engine", model, contexts);
        }
        if (ActivityUtil.isSubprocessActivity(activity) && activity.getImplementationProcess() != null && activity.getImplementationProcess().getFormalParameters() != null) {
            ActivityUtil.addContext("processInterface", model, contexts);
        }
        if (ActivityUtil.isApplicationActivity(activity) && (application = activity.getApplication()) != null) {
            if (application.isInteractive()) {
                model = ModelUtils.findContainingModel(application);
                for (ApplicationContextTypeType ctxType : model.getApplicationContextType()) {
                    if (ActivityUtil.isImplicitContext(ctxType.getId()) || !ActivityUtil.containsCtxType(activity.getApplication(), ctxType)) continue;
                    contexts.add(ctxType);
                }
            } else {
                ActivityUtil.addContext("application", model, contexts);
            }
        }
        return contexts;
    }

    private static boolean containsCtxType(ApplicationType application, ApplicationContextTypeType appCtxType) {
        for (ContextType contextType : application.getContext()) {
            if (!appCtxType.equals(contextType.getType())) continue;
            return true;
        }
        return false;
    }

    private static void addContext(String id, ModelType model, List<ApplicationContextTypeType> contexts) {
        ApplicationContextTypeType ctxType = (ApplicationContextTypeType)ModelUtils.findIdentifiableElement(model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), id);
        if (ctxType != null) {
            contexts.add(ctxType);
        }
    }

    public static ContextType getContext(ActivityType activity, String contextId) {
        ApplicationType application = activity.getApplication();
        if (application != null) {
            for (ContextType context : application.getContext()) {
                if (!CompareHelper.areEqual((Object)context.getType().getId(), (Object)contextId)) continue;
                return context;
            }
        }
        return null;
    }

    public static List<DataMappingType> getDataMappings(ActivityType activity, boolean isIn, String contextId) {
        List dataMappings = CollectionUtils.newList();
        for (DataMappingType mapping : activity.getDataMapping()) {
            if (!contextId.equals(mapping.getContext()) || isIn != AccessPointUtil.isIn(mapping.getDirection())) continue;
            dataMappings.add(mapping);
        }
        return dataMappings;
    }

    public static List<AccessPointType> getAccessPoints(ActivityType activity, boolean isIn, String contextId) {
        return ActivityUtil.getAccessPoints(activity, isIn, true, contextId);
    }

    public static List<AccessPointType> getAccessPoints(ActivityType activity, boolean isIn, boolean includeBrowsables, String contextId) {
        List accessPoints = CollectionUtils.newList();
        if ("engine".equals(contextId)) {
            ModelType containingModel = ModelUtils.findContainingModel(activity);
            if (containingModel != null) {
                EList<DataType> dataList = containingModel.getData();
                if (isIn) {
                    if (ActivityUtil.isSubprocessActivity(activity)) {
                        for (DataType data : dataList) {
                            if (data.isPredefined()) continue;
                            accessPoints.add(AccessPointUtil.createIntrinsicAccessPoint(data.getId(), data.getName(), AttributeUtil.getAttributeValue(data, ActivityUtil.getClassNameAtt(data)), DirectionType.IN_LITERAL, true, null, data.getType()));
                        }
                    }
                } else {
                    accessPoints.add(AccessPointUtil.createIntrinsicAccessPoint("activityInstance", "Activity Instance", "org.eclipse.stardust.engine.api.runtime.ActivityInstance", DirectionType.OUT_LITERAL, true, null, ModelUtils.getDataType(activity, "serializable")));
                    if (ActivityUtil.isSubprocessActivity(activity)) {
                        for (DataType data : dataList) {
                            accessPoints.add(AccessPointUtil.createIntrinsicAccessPoint(data.getId(), data.getName(), AttributeUtil.getAttributeValue(data, ActivityUtil.getClassNameAtt(data)), DirectionType.OUT_LITERAL, true, null, data.getType()));
                        }
                    }
                }
            }
        } else if (!"default".equals(contextId)) {
            ContextType ctx;
            if ("application".equals(contextId)) {
                ApplicationType application = activity.getApplication();
                if (application != null) {
                    accessPoints.addAll(ActivityUtil.getAccessPoints(ActivityUtil.getIntrinsicAccessPoints(application), (List<AccessPointType>)application.getAccessPoint(), isIn, includeBrowsables));
                }
            } else if ("processInterface".equals(contextId)) {
                FormalParametersType paramTypes;
                ProcessDefinitionType subprocess = activity.getImplementationProcess();
                if (subprocess != null && (paramTypes = subprocess.getFormalParameters()) != null) {
                    FormalParameterMappingsType mappingsType = subprocess.getFormalParameterMappings();
                    accessPoints.addAll(ActivityUtil.getAccessPoints(paramTypes, mappingsType, activity, isIn));
                }
            } else if (ActivityUtil.isInteractive(activity) && (ctx = ActivityUtil.getContext(activity, contextId)) != null) {
                accessPoints.addAll(ActivityUtil.getAccessPoints(ActivityUtil.getIntrinsicAccessPoints(ctx), (List<AccessPointType>)ctx.getAccessPoint(), isIn, includeBrowsables));
            }
        }
        return accessPoints;
    }

    private static List<AccessPointType> getAccessPoints(FormalParametersType paramTypes, FormalParameterMappingsType mappingsType, ActivityType activity, boolean isIn) {
        ArrayList<AccessPointType> accessPoints = new ArrayList<AccessPointType>();
        for (FormalParameterType fpt : paramTypes.getFormalParameter()) {
            ModeType mode = fpt.getMode();
            DataType dataType = mappingsType.getMappedData(fpt);
            if (dataType == null || (!isIn || mode == ModeType.OUT) && (isIn || mode == ModeType.IN)) continue;
            accessPoints.add(AccessPointUtil.createAccessPoint(fpt, mappingsType.getMappedData(fpt)));
        }
        return accessPoints;
    }

    private static String getClassNameAtt(DataType data) {
        return null == data.getType() ? null : ("serializable".equals(data.getType().getId()) ? "carnot:engine:className" : ("entity".equals(data.getType().getId()) ? "carnot:engine:remoteInterface" : ("primitive".equals(data.getType().getId()) ? "carnot:engine:type" : null)));
    }

    private static boolean isDataMappingEnabled(ActivityType activity, boolean isIn) {
        if (!ActivityUtil.isSubprocessActivity(activity)) {
            return false;
        }
        boolean isCopyData = isIn ? AttributeUtil.getBooleanValue(activity, "carnot:engine:subprocess:copyAllData") : false;
        return SubProcessModeType.SYNC_SEPARATE_LITERAL.equals((Object)activity.getSubProcessMode()) && !isCopyData;
    }

    public static List<AccessPointType> getExplicitAccessPoints(ActivityType activity, boolean isIn, String contextId) {
        return ActivityUtil.getExplicitAccessPoints(activity, isIn, true, contextId);
    }

    public static List<AccessPointType> getExplicitAccessPoints(ActivityType activity, boolean isIn, boolean includeBrowsables, String contextId) {
        List accessPoints = CollectionUtils.newList();
        if ("engine".equals(contextId) && !isIn) {
            accessPoints.add(AccessPointUtil.createIntrinsicAccessPoint("activityInstance", "Activity Instance", "org.eclipse.stardust.engine.api.runtime.ActivityInstance", DirectionType.OUT_LITERAL, true, null, ModelUtils.getDataType(activity, "serializable")));
        } else if (!"default".equals(contextId)) {
            ContextType ctx;
            if ("application".equals(contextId)) {
                ApplicationType application = activity.getApplication();
                if (null != application) {
                    accessPoints.addAll(ActivityUtil.getAccessPoints(Collections.<AccessPointType>emptyList(), (List<AccessPointType>)application.getAccessPoint(), isIn, includeBrowsables));
                }
            } else if (ActivityUtil.isInteractive(activity) && (ctx = ActivityUtil.getContext(activity, contextId)) != null) {
                accessPoints.addAll(ActivityUtil.getAccessPoints(Collections.<AccessPointType>emptyList(), (List<AccessPointType>)ctx.getAccessPoint(), isIn, includeBrowsables));
            }
        }
        return accessPoints;
    }

    public static List<AccessPointType> getIntrinsicAccessPoints(ITypedElement application) {
        Map<String, IConfigurationElement> types;
        IConfigurationElement config;
        IMetaType type = application.getMetaType();
        if (type != null && (config = (types = SpiExtensionRegistry.instance().getExtensions(type.getExtensionPointId())).get(type.getId())) != null) {
            try {
                IAccessPointProvider provider = (IAccessPointProvider)config.createExecutableExtension("accessPointProvider");
                if (provider != null) {
                    return provider.createIntrinsicAccessPoint((IModelElement)((Object)application));
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static Collection<AccessPointType> getAccessPoints(List<AccessPointType> intrinsicAccessPoints, List<AccessPointType> explicitAccessPoints, boolean isIn, boolean includeBrowsables) {
        List accessPoints = CollectionUtils.newList();
        ActivityUtil.addAll(accessPoints, intrinsicAccessPoints, isIn, includeBrowsables);
        ActivityUtil.addAll(accessPoints, explicitAccessPoints, isIn, includeBrowsables);
        Collections.sort(accessPoints, new Comparator<AccessPointType>(){

            @Override
            public int compare(AccessPointType lhs, AccessPointType rhs) {
                return lhs.getId() == null || rhs.getId() == null ? -1 : CompareHelper.compare((Object)lhs.getName(), (Object)rhs.getName());
            }
        });
        return accessPoints;
    }

    private static void addAll(List<AccessPointType> list, List<AccessPointType> accessPoint, boolean isIn, boolean includeBrowsables) {
        for (AccessPointType ap : accessPoint) {
            if ((!includeBrowsables || !isIn || !AccessPointUtil.isBrowsable(ap)) && !AccessPointUtil.isDirectionCompatible(ap, isIn)) continue;
            list.add(ap);
        }
    }

    public static void updateConnections(ActivityType activity) {
        Set data = CollectionUtils.newSet();
        for (DataMappingType dm : activity.getDataMapping()) {
            if (dm.getData() == null) continue;
            data.add(dm.getData());
        }
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        for (DiagramType diagram : process.getDiagram()) {
            for (DataType dataType : data) {
                ActivityUtil.updateConnections(diagram, activity, dataType);
            }
            ActivityUtil.deleteConnections(diagram, activity, data);
        }
    }

    private static void deleteConnections(DiagramType diagram, ActivityType activity, Set<DataType> data) {
        List deleted = CollectionUtils.newList();
        for (DataMappingConnectionType connection : DiagramUtil.getSymbols(diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_DataMappingConnection(), null)) {
            DataSymbolType dataSymbol = connection.getDataSymbol();
            ActivitySymbolType activitySymbol = connection.getActivitySymbol();
            if (activitySymbol == null || !activitySymbol.getActivity().equals(activity) || dataSymbol == null || data.contains(dataSymbol.getData())) continue;
            deleted.add(connection);
        }
        for (int i = 0; i < deleted.size(); ++i) {
            DataMappingConnectionType connection;
            connection = (DataMappingConnectionType)deleted.get(i);
            connection.setActivitySymbol(null);
            connection.setDataSymbol(null);
            ((ISymbolContainer)connection.eContainer()).getDataMappingConnection().remove((Object)connection);
        }
    }

    private static void updateConnections(DiagramType diagram, ActivityType activity, DataType data) {
        DataSymbolType dataSymbol;
        boolean found = false;
        for (DataMappingConnectionType connection : DiagramUtil.getSymbols(diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_DataMappingConnection(), null)) {
            dataSymbol = connection.getDataSymbol();
            ActivitySymbolType activitySymbol = connection.getActivitySymbol();
            if (activitySymbol == null || !activitySymbol.getActivity().equals(activity) || dataSymbol == null || !dataSymbol.getData().equals(data)) continue;
            connection.setStyle(connection.getStyle());
            found = true;
        }
        if (!found) {
            for (ActivitySymbolType activitySymbol : DiagramUtil.getSymbols(diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), activity)) {
                dataSymbol = (DataSymbolType)DiagramUtil.getClosestSymbol(activitySymbol, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_DataSymbol(), data);
                if (dataSymbol == null) continue;
                DataMappingConnectionType connection = CarnotWorkflowModelFactory.eINSTANCE.createDataMappingConnectionType();
                connection.setActivitySymbol(activitySymbol);
                connection.setDataSymbol(dataSymbol);
                PoolSymbol defaultPool = DiagramUtil.getDefaultPool(diagram);
                defaultPool.getDataMappingConnection().add((Object)connection);
            }
        }
    }

    public static boolean isImplicitContext(String id) {
        return "default".equals(id) || "engine".equals(id) || "application".equals(id) || "processInterface".equals(id);
    }

    public static List<ActivityType> getOutActivities(ActivityType activity) {
        List list = CollectionUtils.newList();
        if (activity != null) {
            for (TransitionType transition : activity.getOutTransitions()) {
                list.add(transition.getTo());
            }
        }
        return list;
    }

    public static boolean hasStartEvent(ActivityType activity) {
        for (INodeSymbol activitySymbol : activity.getSymbols()) {
            for (TransitionConnectionType transition : ((ActivitySymbolType)activitySymbol).getInTransitions()) {
                if (!(transition.getSourceNode() instanceof StartEventSymbol)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasEndEvent(ActivityType activity) {
        for (INodeSymbol activitySymbol : activity.getSymbols()) {
            for (TransitionConnectionType transition : ((ActivitySymbolType)activitySymbol).getOutTransitions()) {
                if (!(transition.getTargetNode() instanceof EndEventSymbol)) continue;
                return true;
            }
        }
        return false;
    }
}

