/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public final class ModelParticipantUtils {
    public static List getAssociatedOrganizations(IModelParticipant participant) {
        ArrayList<EObject> result = null;
        EList<ParticipantType> associations = participant.getParticipantAssociations();
        for (int i = 0; i < associations.size(); ++i) {
            ParticipantType p = (ParticipantType)associations.get(i);
            if (!(p.eContainer() instanceof OrganizationType)) continue;
            if (null == result) {
                result = new ArrayList<EObject>(associations.size());
            }
            result.add(p.eContainer());
        }
        return null != result ? result : Collections.EMPTY_LIST;
    }

    public static OrganizationType findAssociatedOrganization(IModelParticipant participant, String id) {
        OrganizationType result = null;
        EList<ParticipantType> associations = participant.getParticipantAssociations();
        for (int i = 0; i < associations.size(); ++i) {
            ParticipantType p = (ParticipantType)associations.get(i);
            if (!(p.eContainer() instanceof OrganizationType)) continue;
            OrganizationType org = (OrganizationType)p.eContainer();
            if ((null == id || !id.equals(org.getId())) && id != org.getId()) continue;
            result = org;
            break;
        }
        return result;
    }

    public static List findAssociatedRootOrganizations(IModelParticipant participant) {
        ArrayList<IModelParticipant> result = new ArrayList<IModelParticipant>();
        LinkedList<IModelParticipant> pendingParticipants = new LinkedList<IModelParticipant>();
        pendingParticipants.add(participant);
        HashSet<IModelParticipant> resolvedParticipants = new HashSet<IModelParticipant>();
        while (!pendingParticipants.isEmpty()) {
            IModelParticipant candidate = (IModelParticipant)pendingParticipants.remove(0);
            if (resolvedParticipants.contains(candidate)) continue;
            List orgs = ModelParticipantUtils.getAssociatedOrganizations(candidate);
            if (orgs.isEmpty()) {
                result.add(candidate);
            } else {
                pendingParticipants.addAll(orgs);
            }
            resolvedParticipants.add(candidate);
        }
        return result;
    }

    public static List getSubOrganizations(OrganizationType parent) {
        ArrayList<IModelParticipant> result = null;
        EList<ParticipantType> pList = parent.getParticipant();
        for (int i = 0; i < pList.size(); ++i) {
            ParticipantType p = (ParticipantType)pList.get(i);
            if (!(p.getParticipant() instanceof OrganizationType)) continue;
            if (null == result) {
                result = new ArrayList<IModelParticipant>(pList.size());
            }
            result.add(p.getParticipant());
        }
        return null != result ? result : Collections.EMPTY_LIST;
    }

    public static List getSubParticipants(OrganizationType parent) {
        EList<ParticipantType> pList = parent.getParticipant();
        ArrayList<IModelParticipant> result = new ArrayList<IModelParticipant>(pList.size());
        for (int i = 0; i < pList.size(); ++i) {
            ParticipantType p = (ParticipantType)pList.get(i);
            if (null == p.getParticipant()) continue;
            result.add(p.getParticipant());
        }
        return result;
    }

    public static IModelParticipant findSubParticipant(OrganizationType parent, String id) {
        IModelParticipant result = null;
        EList<ParticipantType> pList = parent.getParticipant();
        for (int i = 0; i < pList.size(); ++i) {
            IModelParticipant candidate = ((ParticipantType)pList.get(i)).getParticipant();
            if (null == candidate || (null == id || !id.equals(candidate.getId())) && id != candidate.getId()) continue;
            result = candidate;
            break;
        }
        return result;
    }

    public static boolean isSubOrganizationOf(OrganizationType parent, OrganizationType child, boolean deep) {
        boolean result = false;
        LinkedList<OrganizationType> pendingOrgs = new LinkedList<OrganizationType>();
        pendingOrgs.add(parent);
        HashSet<OrganizationType> resolvedOrgs = new HashSet<OrganizationType>();
        while (!pendingOrgs.isEmpty()) {
            OrganizationType org = (OrganizationType)pendingOrgs.remove(0);
            if (resolvedOrgs.contains(org)) continue;
            if (org == child) {
                result = true;
                break;
            }
            if (!deep && org != parent) continue;
            pendingOrgs.addAll(ModelParticipantUtils.getSubOrganizations(org));
            resolvedOrgs.add(org);
        }
        return result;
    }

    private ModelParticipantUtils() {
    }

    public static IModelParticipant findById(ModelType model, String id) {
        IModelParticipant result = ModelUtils.findIdentifiableElement(model.getOrganization(), id);
        if (null == result) {
            result = ModelUtils.findIdentifiableElement(model.getRole(), id);
        }
        if (null == result) {
            result = ModelUtils.findIdentifiableElement(model.getConditionalPerformer(), id);
        }
        return result;
    }
}

