/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.util;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IPreferenceStore;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;

public class IdFactory {
    private final EClass eTypeTargetType;
    private final EStructuralFeature eFtrId;
    private final EStructuralFeature eFtrName;
    private String baseId;
    private String baseName;
    private String id;
    private String name;
    private IIdentifiableModelElement referingElement;
    private IPreferenceStore preferenceStore;
    private String uniquenessKey;
    private Integer sharedID = null;

    public void setPreferenceStore(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    public void setSharedID(Integer sharedID) {
        this.sharedID = sharedID;
    }

    public IdFactory(String baseId, String baseName, IIdentifiableModelElement referingElement) {
        this(baseId, baseName);
        this.setReferingElement(referingElement);
    }

    public IdFactory(String baseId, String baseName, String uniquenessKey) {
        this(baseId, baseName);
        this.uniquenessKey = uniquenessKey;
    }

    public IdFactory(String baseName) {
        this(baseName, baseName, XpdlPackage.eINSTANCE.getTypeDeclarationType(), (EStructuralFeature)XpdlPackage.eINSTANCE.getTypeDeclarationType_Id(), (EStructuralFeature)XpdlPackage.eINSTANCE.getTypeDeclarationType_Name());
    }

    public IdFactory(String baseId, String baseName) {
        this(baseId, baseName, CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name());
    }

    public IdFactory(String baseId, String baseName, EClass targetType, EStructuralFeature eFtrId, EStructuralFeature eFtrName) {
        this.eTypeTargetType = targetType;
        this.eFtrId = eFtrId;
        this.eFtrName = eFtrName;
        this.baseId = baseId == null || baseName != null && this.getAutoId() ? ModelUtils.computeId(baseName) : baseId;
        this.baseName = baseName;
    }

    public String getId() {
        return this.id == null ? this.baseId : this.id;
    }

    public String getName() {
        return this.name == null ? this.baseName : this.name;
    }

    public IIdentifiableModelElement getReferingElement() {
        return this.referingElement;
    }

    public void setReferingElement(IIdentifiableModelElement referingElement) {
        this.referingElement = referingElement;
        this.uniquenessKey = null != referingElement ? Long.toString(referingElement.getElementOid()) : null;
    }

    public void computeNames(List<? extends EObject> list) {
        this.computeNames(list, true);
    }

    public void computeNames(List<? extends EObject> list, boolean forceSuffix) {
        boolean foundBaseId = false;
        String searchId = this.baseId + "_";
        String searchName = this.baseName != null ? this.baseName + " " : null;
        int counter = 1;
        searchId = this.getAutoId() && searchName != null ? ModelUtils.computeId(searchName) : ModelUtils.computeId(searchId);
        for (EObject eObject : list) {
            String existingName;
            if (!this.eTypeTargetType.isInstance((Object)eObject)) continue;
            String existingId = (String)eObject.eGet(this.eFtrId);
            foundBaseId |= null != existingId && existingId.equals(this.baseId);
            if (existingId != null && existingId.startsWith(searchId)) {
                try {
                    String sn = existingId.substring(searchId.length()).trim();
                    int number = Integer.parseInt(sn);
                    if (number >= counter) {
                        counter = number + 1;
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (null == this.eFtrName || (existingName = (String)eObject.eGet(this.eFtrName)) == null || !existingName.startsWith(searchName)) continue;
            try {
                String sn = existingName.substring(searchName.length()).trim();
                int number = Integer.parseInt(sn);
                if (number < counter) continue;
                counter = number + 1;
            }
            catch (NumberFormatException nfe) {}
        }
        if (this.sharedID != null) {
            this.id = searchId + this.sharedID;
            this.name = searchName + this.sharedID;
        } else if (!foundBaseId && !forceSuffix) {
            this.id = this.baseId;
        } else {
            this.id = searchId + counter;
            if (this.baseName != null) {
                this.name = searchName + counter;
            }
        }
    }

    public boolean getAutoId() {
        if (this.preferenceStore != null) {
            return this.preferenceStore.getAutoId();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdFactory)) {
            return false;
        }
        IdFactory idFactory = (IdFactory)o;
        if (!this.baseId.equals(idFactory.baseId)) {
            return false;
        }
        if (!this.baseName.equals(idFactory.baseName)) {
            return false;
        }
        return !(this.uniquenessKey != null ? !this.uniquenessKey.equals(idFactory.uniquenessKey) : idFactory.uniquenessKey != null);
    }

    public int hashCode() {
        int result = this.baseId.hashCode();
        result = 29 * result + this.baseName.hashCode();
        result = 29 * result + (this.uniquenessKey != null ? this.uniquenessKey.hashCode() : 0);
        return result;
    }
}

