/*******************************************************************************
 * Copyright (c) 2015 SunGard CSA LLC and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html Contributors: SunGard
 * CSA LLC - initial API and implementation and/or initial documentation
 ******************************************************************************/

/**
 * @author Yogesh.Manware
 */

(function() {
  'use strict';

  angular.module('modeler-ui').controller(
          'sdActivityImplementationTaskCtrl',
          ['$scope', 'sdUtilService', 'sdI18nService', 'sdModelerConstants',
              'sdModelerUtilService', ActivityImplementationTaskCtrl]);

  /*
   * 
   */
  function ActivityImplementationTaskCtrl($scope, sdUtilService, sdI18nService,
          sdModelerConstants, sdModelerUtilService) {
    var self = this;
    self.initialized = false;
    self.show = false;

    $scope.sdI18nModeler = sdI18nService.getInstance('bpm-modeler-messages').translate;
    var i18n = $scope.sdI18nModeler;

    $scope
    .$on(
            'REFRESH_PROPERTIES_PANEL',
            function(event, propertiesPanel) {
                      if (!self.initialized) {
                        self.initialized = true;
                      }
                      self.propertiesPanel = propertiesPanel;
                      if (self.propertiesPanel.element.modelElement) {
                        if (self.propertiesPanel.element.modelElement.activityType != sdModelerConstants.SUBPROCESS_ACTIVITY_TYPE) {
                          self.show = true;
                        } else {
                          self.show = false;
                        }
                      }
                      self.reset();
                    }, false);

    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.reset = function() {
      this.element = this.propertiesPanel.element;
      if (!this.element) { return; }

      this.modelElement = this.element.modelElement;

      this.noImplementation = null;
      this.ruleSet = false;
      this.application = false;
      if (this.modelElement.taskType == sdModelerConstants.NONE_TASK_TYPE
              || this.modelElement.taskType == sdModelerConstants.MANUAL_TASK_TYPE) {

        this.noImplementation = this.getNoImplementationMsg();
      } else if (this.modelElement.taskType == sdModelerConstants.RULE_TASK_TYPE) {

        this.populateRuleSetList();
        this.selectedRuleSet = !this.modelElement.attributes["ruleSetId"]
                ? sdModelerConstants.TO_BE_DEFINED
                : this.modelElement.attributes["ruleSetId"];
        this.ruleSet = true;

      } else {
        this.populateApplicationList();
        this.selectedApplication = !this.modelElement.applicationFullId
                ? sdModelerConstants.TO_BE_DEFINED
                : this.modelElement.applicationFullId;
        this.application = true;
      }
    }

    /**
     * @returns
     */
    ActivityImplementationTaskCtrl.prototype.getNoImplementationMsg = function() {
      var message = "";
      if (this.modelElement.taskType == sdModelerConstants.MANUAL_TASK_TYPE) {
        message = i18n("modeler.propertiesPage.activity.implementation.autoGeneratedScreen");
      } else {
        message = i18n("modeler.propertiesPage.activity.implementation.notRequiredAvailable");
      }
      return message;
    }

    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.populateApplicationList = function() {
      this.applicationList = [];

      this.applicationList.push({
        id: sdModelerConstants.TO_BE_DEFINED,
        label: i18n('modeler.general.toBeDefined')
      });

      var appsSorted = sdUtilService.convertToSortedArray(
              this.getModel().applications, "name", true);

      var thisModel = i18n('modeler.general.thisModel');

      for ( var i in appsSorted) {
        if (!this.checkCompatibility(appsSorted[i])) {
          continue;
        }

        this.applicationList.push({
          id: appsSorted[i].getFullId(),
          label: appsSorted[i].name,
          group: thisModel
        })
      }
      var modelsSorted = sdUtilService.convertToSortedArray(this.propertiesPanel
              .getModels(), "name", true);

      var otherModel = i18n('modeler.general.otherModels');

      for ( var n in modelsSorted) {
        if (modelsSorted[n] == this.getModel()) {
          continue;
        }

        var appsSorted = sdUtilService.convertToSortedArray(
                modelsSorted[n].applications, "name", true);

        for ( var m in appsSorted) {
          if (!sdModelerUtilService.hasPublicVisibility(appsSorted[m])) {
            continue;
          }

          if (!this.checkCompatibility(appsSorted[m])) {
            continue;
          }

          this.applicationList.push({
            id: appsSorted[m].getFullId(),
            label: modelsSorted[n].name + "/" + appsSorted[m].name,
            group: otherModel
          })
        }
      }
    }
    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.populateRuleSetList = function() {
      this.ruleSetList = [];
      this.ruleSetList.push({
        id: sdModelerConstants.TO_BE_DEFINED,
        label: i18n("modeler.general.toBeDefined")
      });

      var ruleSets = this.propertiesPanel.getRuleSets();

      if (ruleSets) {
        ruleSets = sdUtilService.convertToSortedArray(ruleSets, "name", true);
        for ( var i in ruleSets) {
          if (ruleSets[i].state.isDeleted != true) {
            this.ruleSetList.push({
              id: ruleSets[i].id,
              label: ruleSets[i].name
            });
          }
        }
      }
    };

    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.openApplication = function() {
      var application = this.propertiesPanel
              .findApplication(this.selectedApplication);
      this.propertiesPanel.openApplicationView(application);
    }

    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.isLinkDisabled = function() {
      if (!this.selectedApplication
              || this.selectedApplication == sdModelerConstants.TO_BE_DEFINED) { return true; }
      return false;
    }

    /**
     * @param application
     * @returns {Boolean}
     */
    ActivityImplementationTaskCtrl.prototype.checkCompatibility = function(
            application) {
      if (application
              && this.modelElement.taskType === application
                      .getCompatibleActivityTaskType()) { return true; }

      return false;
    }

    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.onImplementationChange = function() {
      this.submitImplementionChanges();
    }

    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.onRuleSetChange = function() {
      this.submitRuleSetChanges();
    }

    /**
     * @returns
     */
    ActivityImplementationTaskCtrl.prototype.getModel = function() {
      return this.propertiesPanel.propertiesPage.getModel();
    }

    // Server Interaction
    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.submitImplementionChanges = function() {
      this.propertiesPanel
              .submitChanges({
                modelElement: {
                  applicationFullId: this.selectedApplication == sdModelerConstants.TO_BE_DEFINED
                          ? null : this.selectedApplication
                }
              });
    }

    /**
     * 
     */
    ActivityImplementationTaskCtrl.prototype.submitRuleSetChanges = function() {
      this.propertiesPanel.submitChanges({
        modelElement: {
          attributes: {
            ruleSetId: this.selectedRuleSet
          }
        }
      });
    }
  }
})();