/*******************************************************************************
 * Copyright (c) 2011 SunGard CSA LLC and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: SunGard CSA LLC - initial API and implementation and/or initial
 * documentation
 ******************************************************************************/

/**
 * @author Shrikant.Gangal
 */
define(
		[ "bpm-modeler/js/m_utils", "bpm-modeler/js/m_constants",
				"bpm-modeler/js/m_propertiesPage",
				"bpm-modeler/js/m_i18nUtils", "bpm-modeler/js/m_angularContextUtils",
				"bpm-modeler/js/m_command", "bpm-modeler/js/m_commandsController",
				"bpm-modeler/js/m_urlUtils", "bpm-modeler/js/m_modelsSaveStatus"],
		function(m_utils, m_constants, m_propertiesPage, m_i18nUtils, m_angularContextUtils,
				m_command, m_commandsController, m_urlUtils, m_modelsSaveStatus) {
			return {
				create : function(propertiesPanel, id) {
					var page = new ModelReadOnlyPropertiesPage(
							propertiesPanel, id);

					page.initialize();

					return page;
				}
			};

			/**
			 *
			 */
			function ModelReadOnlyPropertiesPage(propertiesPanel, id) {
				var propertiesPage = m_propertiesPage.createPropertiesPage(
						propertiesPanel, id, "Configuration Variables",
						"plugins/bpm-modeler/images/icons/table.png");

				m_utils.inheritFields(this, propertiesPage);
				m_utils.inheritMethods(
						ModelReadOnlyPropertiesPage.prototype,
						propertiesPage);
				this.submitReadOnlyButton = m_utils.jQuerySelect("#submitReadOnly");
				this.passwordInput = m_utils.jQuerySelect("#password");
				this.reenterInput = m_utils.jQuerySelect("#rePassword");

				/**
				 *
				 */
				ModelReadOnlyPropertiesPage.prototype.initialize = function() {
					m_utils.jQuerySelect("#readOnlyModelHeading")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.writableHeading"));
					m_utils.jQuerySelect("label[for='readOnlyStatus']")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.statusLabel"));
					m_utils.jQuerySelect("label[for='password']")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.passwordLabel"));
					m_utils.jQuerySelect("label[for='rePassword']")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.reenterLabel"));
					m_utils.jQuerySelect("#passwordsEmptyErrorDiv")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.error.passwordsEmpty"));
					m_utils.jQuerySelect("#reEnterPasswordErrorDiv")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.error.reEnterPassword"));
					m_utils.jQuerySelect("#minLengthErrorDiv")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.error.minLength"));
					m_utils.jQuerySelect("#passwordMismatchErrorDiv")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.error.passwordMismatch"));

					var page = this;

					// NOTE: The angular initialization and boot-strapping is done
					// after the tab is switched (tab are generated by jQuery UI and it was observed)
					// the bootstrapping is lost if it's done before tab generation.
					m_utils.jQuerySelect("a[href='#modelReadOnlyPropertiesPage']").click(function() {
						m_angularContextUtils.runInAngularContext(function($scope) {

							$scope.readonlyModel = page.getModelElement() && page.getModelElement().isReadonly();
							// TODO - improve validate
							// user built in directives for min-length
							$scope.validate = function() {
								$scope.reEnterPasswordError = false;
								$scope.passwordMismatchError = false;
								$scope.minLengthError = false;
								$scope.passwordsEmpty = false;
								if (!$scope.readonlyModel) {
									if ((!m_utils.isEmptyString($scope.password) && $scope.password.length < 4)) {
											$scope.minLengthError = true;
									} else if ((!m_utils.isEmptyString($scope.password) && m_utils.isEmptyString($scope.rePassword))
											|| (!m_utils.isEmptyString($scope.rePassword) && m_utils.isEmptyString($scope.password))) {
										$scope.reEnterPasswordError = true;
									} else {
										if ($scope.password !== $scope.rePassword) {
											$scope.passwordMismatchError = true;
										} else {
											$scope.passwordMismatchError = false;
										}
									}
								}

								$scope.invalidPassword = $scope.passwordsEmpty || $scope.reEnterPasswordError || $scope.passwordMismatchError || $scope.minLengthError;

								return !$scope.invalidPassword;
							};

							$scope.submitReadOnly = function() {
								if (m_utils.isEmptyString($scope.password)
										|| (!$scope.readonlyModel && m_utils.isEmptyString($scope.rePassword))) {
									$scope.passwordsEmpty = true;
								} else if ($scope.validate()) {
									$scope.passwordsEmpty = false;
									page.toggleModelReadOnlyStatus($scope.password);
								}

							};

							$scope.$watch("password", function(newValue, oldValue) {
								$scope.validate();
							});
							$scope.$watch("rePassword", function(newValue, oldValue) {
								$scope.validate();
							});

							$scope.invalidPassword = true;
						}, m_utils.jQuerySelect("#modelReadOnlyDiv").get(0));
					});
				};

				ModelReadOnlyPropertiesPage.prototype.isInputValid = function(
						$scope) {
					var thisModel = this.getModelElement();
					if (thisModel && thisModel.isReadonly()) {
						if (m_utils.isEmptyString(this.passwordInput.val()
								.trim())) {
							setScopeProperty("passwordsEmpty", true);
							return false;
						} else {
							setScopeProperty("passwordsEmpty", false);
						}
					} else {
						if (m_utils.isEmptyString(this.passwordInput.val()
								.trim())
								|| m_utils.isEmptyString(this.reenterInput
										.val().trim())) {
							this.setScopeProperty("passwordsEmpty", true);
							return false;
						} else {
							this.setScopeProperty("passwordsEmpty", false);
						}
					}

					return true;
				};

				ModelReadOnlyPropertiesPage.prototype.setScopeProperty = function(property, value) {
					m_angularContextUtils.runInAngularContext(function($scope) {
						if ($scope && property) {
							$scope[property] = value;
						}
					}, m_utils.jQuerySelect("#modelReadOnlyDiv").get(0));
				};

				/**
				 *
				 */
				ModelReadOnlyPropertiesPage.prototype.toggleModelReadOnlyStatus = function() {
					var thisModel = this.getModelElement();
					if (thisModel) {
						if (!thisModel.isReadonly()) {
							if (false == m_modelsSaveStatus.areModelsSaved()) {
								if (parent.iPopupDialog) {
									parent.iPopupDialog
											.openPopup({
												attributes : {
													width : "400px",
													height : "200px",
													src : "../bpm-modeler/popups/confirmationPopupDialogContent.html"
												},
												payload : {
													title : m_i18nUtils
															.getProperty("modeler.messages.warning"),
													message : m_i18nUtils
															.getProperty("modeler.messages.info.modelNotSaved"),
													acceptButtonText : m_i18nUtils
															.getProperty("modeler.messages.confirm.close"),
													acceptFunction : function() {
														// Do nothing
													}
												}
											});
								} else {
									alert("Models have unsaved changes. Please save models before continuing.");
								}
							} else {
								this.submitReadOnlyStatus();
							}
						} else {
							this.submitReadOnlyStatus();
						}
					}
				};

				/**
				 *
				 */
				ModelReadOnlyPropertiesPage.prototype.submitReadOnlyStatus = function() {
					var thisModel = this.getModelElement();
					if (thisModel) {
						var view = this;
						view.propertiesPanel.clearErrorMessages();
						var promise = m_commandsController.submitCommand(m_command
								.createUpdateModelLockStatusCommand(
										thisModel.uuid, thisModel.id, {
											readOnly : !thisModel.isReadonly(),
											password : this.passwordInput.val()
										}));

						// If the submit call succeeds then the response is broadcasted as usual.
						// If it fails, the following function will be executed to show
						// invalid password message.
						promise.fail(function(command) {
							if (command.problems.length > 0) {
								view.propertiesPanel.errorMessages.push(m_i18nUtils.getProperty(command.problems[0].message));
								view.propertiesPanel.showErrorMessages();
							} else {
								view.propertiesPanel.errorMessages.push(m_i18nUtils.getProperty("Unknown error while changing model lock status."));
								view.propertiesPanel.showErrorMessages();
							}
						});
					}
				};

				/**
				 *
				 */
				ModelReadOnlyPropertiesPage.prototype.setElement = function() {
					var thisModel = this.getModelElement();
					if (thisModel) {
						if (thisModel.isReadonly()) {
							this.setReadOnly();
						} else {
							this.setWritable();
						}
					}

					m_angularContextUtils.runInAngularContext(function($scope) {
						$scope.readonlyModel = thisModel.isReadonly();
						$scope.password = "";
						$scope.rePassword = "";
					}, m_utils.jQuerySelect("#modelReadOnlyDiv").get(0));

					if (thisModel.isReadonly()) {
						this.submitReadOnlyButton
								.val(m_i18nUtils
										.getProperty("modeler.propertyView.modelView.readOnlyPage.submitButtonLabel.makeWritable"));
					} else {
						this.submitReadOnlyButton
								.val(m_i18nUtils
										.getProperty("modeler.propertyView.modelView.readOnlyPage.submitButtonLabel.makeReadOnly"));
					}
				};

				/**
				 *
				 */
				ModelReadOnlyPropertiesPage.prototype.setReadOnly = function() {
					m_utils.jQuerySelect("label#readOnlyStatus")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.statusReadOnly"));
					m_utils.jQuerySelect("#readOnlyModelHeading")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.readOnlyHeading"));
				};

				/**
				 *
				 */
				ModelReadOnlyPropertiesPage.prototype.setWritable = function() {
					m_utils.jQuerySelect("label#readOnlyStatus")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.statusWritable"));
					m_utils.jQuerySelect("#readOnlyModelHeading")
							.text(
									m_i18nUtils
											.getProperty("modeler.propertyView.modelView.readOnlyPage.writableHeading"));
				};
			};
		});