/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.drawing;

import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;

public class Metrics {
    Rectangle2D canvasRectangle;
    Rectangle2D plotRectangle;
    Rectangle2D valueRectangle;

    public Metrics(Rectangle2D canvasRectangle, double l, double t, double r, double b) {
        this.canvasRectangle = canvasRectangle;
        this.plotRectangle = l + r < this.canvasRectangle.getSize().getX() && t + b < this.canvasRectangle.getSize().getY() ? new Rectangle2D(this.canvasRectangle.getMinCorner().plus(new Coord2D(l, t)), this.canvasRectangle.getMaxCorner().minus(new Coord2D(r, b))) : new Rectangle2D(this.canvasRectangle.getMinCorner(), this.canvasRectangle.getMaxCorner());
        this.valueRectangle = new Rectangle2D(0.0, 0.0, 100.0, 100.0);
    }

    public void initValueRectangle(Rectangle2D valueRectangle) {
        this.valueRectangle = valueRectangle != null ? valueRectangle : new Rectangle2D(0.0, 0.0, 0.0, 0.0);
    }

    public Coord2D[] transposeToCanvas(Coord2D[] p) {
        Coord2D[] result = new Coord2D[p.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.transposeToCanvas(p[i]);
            ++i;
        }
        return result;
    }

    public Coord2D transposeToCanvas(Coord2D p) {
        Coord2D pRelative = p.minus(this.valueRectangle.getMinCorner());
        Coord2D pScaled = pRelative.multiply(this.plotRectangle.getSize()).divide(this.valueRectangle.getSize());
        Coord2D pResult = pScaled.plus(this.plotRectangle.getMinCorner());
        return new Coord2D(pResult.getX(), this.canvasRectangle.getMaxCorner().getY() - pResult.getY());
    }

    public Coord2D transposeToValue(Coord2D p) {
        Coord2D pInverse = new Coord2D(p.getX(), this.canvasRectangle.getMaxCorner().getY() - p.getY());
        Coord2D pRelative = pInverse.minus(this.plotRectangle.getMinCorner());
        Coord2D pScaled = pRelative.multiply(this.valueRectangle.getSize()).divide(this.plotRectangle.getSize());
        Coord2D pResult = pScaled.plus(this.valueRectangle.getMinCorner());
        return pResult;
    }

    public Rectangle2D transposeToValue(Rectangle2D p) {
        return new Rectangle2D(this.transposeToValue(p.getMinCorner()), this.transposeToValue(p.getMaxCorner()));
    }

    public Rectangle2D getCanvasRectangle() {
        return this.canvasRectangle;
    }

    public Rectangle2D getPlotRectangle() {
        return this.plotRectangle;
    }

    public Rectangle2D getValueRectangle() {
        return this.valueRectangle;
    }
}

