/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.geometry;

import org.eclipse.swt.graphics.Point;

public class Coord2D {
    double x;
    double y;

    public Coord2D(Coord2D r) {
        this.x = r.x;
        this.y = r.y;
    }

    public Coord2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Coord2D plus(Coord2D r) {
        return new Coord2D(this.x + r.x, this.y + r.y);
    }

    public Coord2D minus(Coord2D r) {
        return new Coord2D(this.x - r.x, this.y - r.y);
    }

    public Coord2D minus() {
        return new Coord2D(-this.x, -this.y);
    }

    public Coord2D multiply(Coord2D r) {
        return new Coord2D(this.x * r.x, this.y * r.y);
    }

    public Coord2D multiply(double d) {
        return new Coord2D(this.x * d, this.y * d);
    }

    public Coord2D divide(Coord2D r) {
        return new Coord2D(this.x / r.x, this.y / r.y);
    }

    public Coord2D divide(double d) {
        return new Coord2D(this.x / d, this.y / d);
    }

    public Coord2D max(Coord2D right) {
        return new Coord2D(Math.max(this.x, right.x), Math.max(this.y, right.y));
    }

    public Coord2D min(Coord2D right) {
        return new Coord2D(Math.min(this.x, right.x), Math.min(this.y, right.y));
    }

    public double distance(Coord2D right) {
        return this.minus(right).sqrt();
    }

    public double distanceX(Coord2D right) {
        return Math.abs(this.minus(right).getX());
    }

    public double distanceY(Coord2D right) {
        return Math.abs(this.minus(right).getY());
    }

    public double distanceAprox(Coord2D right) {
        return Math.abs(this.x - right.x) + Math.abs(this.y - right.y);
    }

    public double sqrt() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double area() {
        return this.x * this.y;
    }

    public boolean inside(Coord2D pos, Coord2D size) {
        if (this.x < pos.x) {
            return false;
        }
        if (this.y < pos.y) {
            return false;
        }
        if (this.x > pos.x + size.x) {
            return false;
        }
        return !(this.y > pos.y + size.y);
    }

    public static Coord2D swt2model(Point p) {
        return new Coord2D(p.x, p.y);
    }

    public static Point model2swt(Coord2D c) {
        return new Point((int)Math.round(c.x), (int)Math.round(c.y));
    }

    public static Point[] model2swt(Coord2D[] c) {
        Point[] result = new Point[c.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new Point((int)Math.round(c[i].x), (int)Math.round(c[i].y));
            ++i;
        }
        return result;
    }

    public String toString() {
        return "[" + this.x + ";" + this.y + "]";
    }
}

