/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayerBase;
import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.GCDrawingUtils;

public class CurveDescriptionLayer
extends CurveLayerBase {
    String text;
    double xAlignment;
    double yAlignment;

    public CurveDescriptionLayer(CurveLayer wrapped, String text, double xAlignment, double yAlignment) {
        super(wrapped);
        this.text = text;
        this.xAlignment = xAlignment;
        this.yAlignment = yAlignment;
    }

    public CurveDescriptionLayer(CurveLayer wrapped, String text) {
        this(wrapped, text, 1.0, 0.0);
    }

    public CurveDescriptionLayer(String text, CurveLayer wrapped, double xAlignment, double yAlignment) {
        this(wrapped, text, xAlignment, yAlignment);
    }

    public CurveDescriptionLayer(String text, CurveLayer wrapped) {
        this(wrapped, text, 1.0, 0.0);
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        super.draw(gc, metrics, configuration);
        gc.pushState();
        double x = metrics.getPlotRectangle().getMinCorner().getX() + metrics.getPlotRectangle().getSize().getX() * this.xAlignment;
        double y = metrics.getPlotRectangle().getMinCorner().getY() + metrics.getPlotRectangle().getSize().getY() * this.yAlignment;
        gc.setForegroundColor(this.getColor(configuration));
        gc.setFont(configuration.getNotesFontObject());
        GCDrawingUtils gcutils = new GCDrawingUtils(gc);
        gcutils.drawText(this.text, (int)x, (int)y, this.xAlignment, this.yAlignment);
        gc.popState();
    }
}

