/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.GCDrawingUtils;
import org.eclipse.swt.graphics.Point;

public class PCentLayer
implements Layer {
    DecimalFormat scaleFormat = new DecimalFormat("###'%'", new DecimalFormatSymbols(Locale.US));
    double value100pcent;
    double ticks = 10.0;

    public PCentLayer(double value100pcent) {
        this.value100pcent = value100pcent;
    }

    public PCentLayer() {
        this.value100pcent = 1.0;
    }

    public void updateTickSizes(double ydiff, int pdiff) {
        if (ydiff < 1.0) {
            if (ydiff < 0.1) {
                this.ticks = 0.01;
            } else if (ydiff < 0.2) {
                this.ticks = 0.02;
            } else if (ydiff < 0.5) {
                this.ticks = 0.05;
            }
            double resolution = Math.abs((double)pdiff * this.ticks / ydiff);
            while (resolution < 30.0) {
                this.ticks *= 2.5;
                resolution = Math.abs((double)pdiff * this.ticks / ydiff);
            }
        } else {
            double[] preferred = new double[]{0.1, 0.25, 0.5, 1.0};
            int i = 0;
            while (i < preferred.length) {
                this.ticks = preferred[i];
                double resolution = Math.abs((double)pdiff * this.ticks / ydiff);
                if (!(resolution >= 30.0)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        Coord2D c0 = new Coord2D(0.0, metrics.getValueRectangle().getMinCorner().getY());
        Coord2D cn = new Coord2D(0.0, metrics.getValueRectangle().getMaxCorner().getY());
        Point p0 = Coord2D.model2swt(metrics.transposeToCanvas(c0));
        Point pn = Coord2D.model2swt(metrics.transposeToCanvas(cn));
        int arrowSize = configuration.getArrowSize();
        this.updateTickSizes(cn.minus(c0).getY(), pn.y - p0.y);
        gc.pushState();
        gc.setForegroundColor(configuration.getAxesColorObject());
        gc.drawLine(p0.x, p0.y, pn.x, pn.y);
        this.drawTicks(gc, metrics, c0, cn, new Coord2D(0.0, this.ticks), configuration.getSmallTickSize());
        gc.setFont(configuration.getScaleFontObject());
        this.drawScale(gc, metrics, c0, cn, new Coord2D(0.0, this.ticks), configuration.getTextOffset());
        GCDrawingUtils gcutils = new GCDrawingUtils(gc);
        gcutils.drawText("", pn.x - arrowSize, pn.y, 131072);
        gc.popState();
    }

    public void drawTicks(Graphics gc, Metrics metrics, Coord2D min, Coord2D max, Coord2D step, int size) {
        Point p;
        Coord2D c = new Coord2D(0.0, 0.0);
        while (c.getY() <= max.getY()) {
            p = Coord2D.model2swt(metrics.transposeToCanvas(c));
            gc.drawLine(p.x - size, p.y, p.x + size, p.y);
            c = c.plus(step);
        }
        c = new Coord2D(0.0, -step.getY());
        while (c.getY() >= min.getY()) {
            p = Coord2D.model2swt(metrics.transposeToCanvas(c));
            gc.drawLine(p.x - size, p.y, p.x + size, p.y);
            c = c.minus(step);
        }
    }

    public void drawScale(Graphics gc, Metrics metrics, Coord2D min, Coord2D max, Coord2D step, int offset) {
        Point p;
        GCDrawingUtils gcutils = new GCDrawingUtils(gc);
        Coord2D c = new Coord2D(0.0, 0.0);
        while (c.getY() <= max.getY()) {
            p = Coord2D.model2swt(metrics.transposeToCanvas(c));
            gcutils.drawText(this.scaleFormat.format(c.getY() * 100.0 / this.value100pcent), p.x - offset, p.y, 131072);
            c = c.plus(step);
        }
        c = new Coord2D(0.0, -step.getY());
        while (c.getY() >= min.getY()) {
            p = Coord2D.model2swt(metrics.transposeToCanvas(c));
            gcutils.drawText(this.scaleFormat.format(c.getY() * 100.0 / this.value100pcent), p.x - offset, p.y, 131072);
            c = c.minus(step);
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }
}

