/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.timeline;

import java.util.Date;
import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.SelectionLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DiscreteCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DottedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StrokedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.WrapperLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.EditableDiscreteDataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class TimelineCurveEditorBase
extends TimelineEditor {
    WrapperLayer selectionSlot = new WrapperLayer();
    WrapperLayer previewSlot = new WrapperLayer();
    Rectangle2D sensivity;

    public TimelineCurveEditorBase(Composite parent, int style, Configuration configuration) {
        super(parent, style, configuration);
    }

    @Override
    public void setTimeline(Date startDate, Date endDate, String label, int unitType, double unitSize, Coord2D snapSize) {
        super.setTimeline(startDate, endDate, label, unitType, unitSize, snapSize);
        this.drawing.addLayer(this.selectionSlot);
        this.drawing.addLayer(this.previewSlot);
        this.redraw();
    }

    @Override
    public void setCurveData(Coord2D[] points) {
        super.setCurveData(points);
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.selectionSlot.setDelegate(new DottedCurveLayer(new DiscreteCurveLayer(new SelectionLayer(this.curve, this.drawing.getConfiguration().getCurveColors()[1]))));
            }
        }
        this.redraw();
    }

    @Override
    public void actionExecute(Coord2D point, boolean appendMode) {
        Coord2D found = this.curve.isNearVertical(point = this.adjustDrawingConstraints(new Coord2D(point), 768), this.sensivity.getSize().getX());
        if (found == null && appendMode) {
            found = this.curve.getHorizontal(point);
        }
        if (found != null && !this.curve.isFixed(found)) {
            this.curve.clearSelection();
            this.curve.deletePoint(found);
            this.notifyListenersOnExecute(found, 256);
        } else {
            found = this.curve.isNearHorizontal(point, this.sensivity.getSize().getY());
            if (found != null) {
                this.curve.clearSelection();
                this.curve.addPointAt(point.getX());
                this.notifyListenersOnExecute(found, 512);
            }
        }
        this.redraw();
    }

    @Override
    public void actionSelect(Coord2D point, boolean appendMode) {
        Coord2D found = this.curve.isNearVertical(point, this.sensivity.getSize().getX());
        if (found != null) {
            this.curve.setSelectionDirection(256);
            this.curve.setSelection(found);
            this.notifyListenersOnSelect(found, 256);
        } else {
            found = this.curve.isNearHorizontal(point, this.sensivity.getSize().getY());
            if (found != null) {
                this.curve.setSelectionDirection(512);
                this.curve.setSelection(found);
                this.notifyListenersOnSelect(found, 512);
            } else {
                this.curve.clearSelection();
            }
        }
        this.redraw();
    }

    @Override
    public void actionPopup(Coord2D point, boolean appendMode) {
        Coord2D found;
        if (this.getMenu() != null) {
            this.getMenu().setVisible(false);
        }
        if ((found = this.curve.isNearVertical(point, this.sensivity.getSize().getX())) != null) {
            this.curve.setSelectionDirection(256);
            this.curve.setSelection(found);
            this.notifyListenersOnPopup(found, 256);
        } else {
            found = this.curve.isNearHorizontal(point, this.sensivity.getSize().getY());
            if (found != null) {
                this.curve.setSelectionDirection(512);
                this.curve.setSelection(found);
                this.notifyListenersOnPopup(found, 512);
            } else {
                this.curve.clearSelection();
                if (this.getMenu() != null) {
                    this.getMenu().setVisible(true);
                }
            }
        }
        this.redraw();
    }

    @Override
    public void actionDragCommit(Coord2D source, Coord2D distance, Coord2D target) {
        this.previewSlot.setDelegate(null);
        Coord2D[] selected = this.curve.getSelection();
        Coord2D[] changed = this.calculateDrag(selected, distance);
        this.curve.replacePoints(selected, changed);
        this.curve.clearSelection();
        int i = 0;
        while (i < changed.length) {
            this.curve.addSelection(changed[i]);
            ++i;
        }
        if (selected.length > 0) {
            this.notifyListenersOnDrag(selected[0], changed[0], this.curve.getSelectionDirection());
            this.notifyListenersOnDragEnd();
        }
        this.redraw();
    }

    @Override
    public void actionDragAbort() {
        this.previewSlot.setDelegate(null);
        this.redraw();
    }

    @Override
    public void actionDragPreview(Coord2D source, Coord2D distance, Coord2D target) {
        Coord2D[] selected = this.curve.getSelection();
        Coord2D[] changed = this.calculateDrag(selected, distance);
        EditableDiscreteDataProvider preview = new EditableDiscreteDataProvider(this.curve.getDiscretePoints());
        preview.replacePoints(selected, changed);
        this.previewSlot.setDelegate(new StrokedCurveLayer(preview, this.drawing.getConfiguration().getCurveColors()[2]){

            @Override
            protected void drawLine(Graphics gc, int index0, Point point0, int index1, Point point1) {
                gc.setLineStyle(3);
                super.drawLine(gc, index0, point0, index1, point1);
            }
        });
        if (selected.length > 0) {
            this.notifyListenersOnDrag(selected[0], changed[0], this.curve.getSelectionDirection());
        }
        this.redraw();
    }

    @Override
    public void actionMovePreview(Coord2D position) {
        Coord2D found = this.curve.isNearVertical(position, this.sensivity.getSize().getX());
        if (found != null) {
            this.setCursor(this.getDisplay().getSystemCursor(9));
            this.notifyListenersOnPoint(found, 256);
        } else {
            found = this.curve.isNearHorizontal(position, this.sensivity.getSize().getY());
            if (found != null) {
                this.setCursor(this.getDisplay().getSystemCursor(7));
                this.notifyListenersOnPoint(found, 512);
            } else {
                this.setCursor(this.getDisplay().getSystemCursor(0));
                this.notifyListenersOnPoint(null, 0);
            }
        }
    }

    private Coord2D[] calculateDrag(Coord2D[] selected, Coord2D distance) {
        distance = this.curve.adjustSelectionConstraints(distance, this.snapSize);
        Coord2D[] changed = new Coord2D[selected.length];
        int i = 0;
        while (i < selected.length) {
            changed[i] = this.curve.isFixed(selected[i]) ? selected[i].plus(new Coord2D(0.0, distance.getY())) : selected[i].plus(distance);
            changed[i] = this.adjustDrawingConstraints(changed[i], this.curve.getSelectionDirection());
            ++i;
        }
        return changed;
    }

    private Coord2D adjustDrawingConstraints(Coord2D c, int selectionDirection) {
        double x = c.getX();
        if ((selectionDirection & 0x100) != 0 && this.snapSize.getX() > 0.0) {
            x = (double)Math.round(x / this.snapSize.getX()) * this.snapSize.getX();
        }
        double y = c.getY();
        if ((selectionDirection & 0x200) != 0 && this.snapSize.getY() > 0.0) {
            y = (double)Math.round(y / this.snapSize.getY()) * this.snapSize.getY();
        }
        c = new Coord2D(x, y);
        return this.constraints == null ? c : this.constraints.adjust(c);
    }

    @Override
    public void updateSensivity(Rectangle2D sensivity) {
        this.sensivity = sensivity.transform(sensivity.getMinCorner().plus(sensivity.getSize().multiply(0.5)).minus());
    }
}

