/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.timeline;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DiscreteIntegral;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Drawing;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.DragListener;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.DragListenerMulticast;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.Editor;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.EditorController;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CalendarLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DefaultDynamicAxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DiscreteCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DottedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.GuaranteeVisibility;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.OldTimeAxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.PCentLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.ProbabilityAreasLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.TimeXAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.WrapperLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.YAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.CurveAreaCompensationHelper;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.EditableDiscreteDataProvider;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class TimelineEditor
extends Canvas
implements Editor {
    public static final int TYPE_PERCENTAGE = 1;
    public static final int TYPE_CALENDAR_ON_OFF = 2;
    public static final int TYPE_CALENDAR_VALUE = 3;
    public static final int TYPE_CUSTOM_CURVE = 4;
    public static final int TYPE_PROBABILITY = 5;
    public static final int TYPE_ARRIVAL_RATE = 6;
    WrapperLayer curveSlot;
    EditableDiscreteDataProvider curve;
    Drawing drawing;
    EditorController controller;
    Rectangle2D constraints;
    int type;
    int unitType;
    Coord2D snapSize;
    DragListener listener;
    DiscreteIntegral integral;
    Date startDate;
    Date endDate;

    public TimelineEditor(Composite parent, int style, Configuration configuration) {
        super(parent, style);
        this.drawing = new Drawing(configuration);
        this.addPaintListener(this.drawing);
        this.controller = new EditorController(this);
        this.addMouseListener(this.controller);
        this.addMouseMoveListener(this.controller);
        this.curveSlot = new WrapperLayer();
    }

    @Override
    public Metrics getMetrics() {
        return this.drawing.getMetrics();
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getUnitType() {
        return this.unitType;
    }

    public void setTimeline(Date startDate, Date endDate, String label, int unitType, double unitSize, Coord2D snapSize) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.snapSize = snapSize;
        this.unitType = unitType;
        this.drawing.removeAllLayers();
        switch (this.type) {
            case 2: 
            case 3: 
            case 5: {
                Calendar c0 = Calendar.getInstance();
                c0.setTime(startDate);
                Calendar c1 = Calendar.getInstance();
                c1.setTime(endDate);
                this.drawing.addLayer(new CalendarLayer(c0, c1, 6, "dd MMM yy"));
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                this.drawing.addLayer(new TimeXAxisLayer(label, unitType));
            }
        }
        switch (this.type) {
            case 2: {
                break;
            }
            case 3: {
                this.drawing.addLayer(new YAxisLayer("N", null, new DefaultDynamicAxisLabeling(), false));
                break;
            }
            case 5: {
                this.drawing.addLayer(new YAxisLayer("%", null, new DefaultDynamicAxisLabeling(), false));
                break;
            }
            case 1: {
                this.drawing.addLayer(new PCentLayer(1.0));
                break;
            }
            case 4: 
            case 6: {
                this.integral = new DiscreteIntegral(false);
                this.drawing.addLayer(new ProbabilityAreasLayer(this.integral, 1));
            }
        }
        switch (this.type) {
            case 2: {
                this.constraints = new Rectangle2D(new Coord2D(0.0, 0.0), new Coord2D(endDate.getTime() - startDate.getTime(), unitSize));
                this.drawing.addLayer(new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
                this.drawing.addLayer(new GuaranteeVisibility(new Coord2D(OldTimeAxisLabeling.getMaxTimelineValue(unitType), unitSize)));
                break;
            }
            case 3: {
                this.constraints = new Rectangle2D(new Coord2D(0.0, 0.0), new Coord2D(endDate.getTime() - startDate.getTime(), Double.MAX_VALUE));
                this.drawing.addLayer(new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
                this.drawing.addLayer(new GuaranteeVisibility(new Coord2D(OldTimeAxisLabeling.getMaxTimelineValue(unitType), 2.0 * unitSize)));
                break;
            }
            case 5: {
                this.constraints = new Rectangle2D(new Coord2D(0.0, 0.0), new Coord2D(endDate.getTime() - startDate.getTime(), 100.0));
                this.drawing.addLayer(new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
                this.drawing.addLayer(new GuaranteeVisibility(new Coord2D(OldTimeAxisLabeling.getMaxTimelineValue(unitType), unitSize * 1.2)));
                break;
            }
            case 1: {
                this.constraints = new Rectangle2D(new Coord2D(0.0, 0.0), new Coord2D(OldTimeAxisLabeling.getMaxTimelineValue(unitType), 1.0));
                this.drawing.addLayer(new GuaranteeVisibility(this.constraints.getMinCorner()));
                this.drawing.addLayer(new GuaranteeVisibility(this.constraints.getMaxCorner()));
                break;
            }
            case 4: {
                this.drawing.addLayer(new GuaranteeVisibility(new Coord2D(0.0, 1.0E-6)));
            }
            case 6: {
                this.constraints = new Rectangle2D(new Coord2D(0.0, 0.0), new Coord2D(Double.MAX_VALUE, Double.MAX_VALUE));
                this.drawing.addLayer(new GuaranteeVisibility(this.constraints.getMinCorner()));
                this.drawing.addLayer(new GuaranteeVisibility(new Coord2D(0.0, 1.0E-6)));
            }
        }
        this.drawing.addLayer(this.curveSlot);
        this.redraw();
    }

    public Coord2D[] getCurveData() {
        return this.curve != null ? this.curve.getDiscretePoints() : new Coord2D[]{};
    }

    public void setCurveData(Coord2D[] points) {
        switch (this.type) {
            case 2: {
                this.curve = new EditableDiscreteDataProvider(points);
                this.curveSlot.setDelegate(new DiscreteCurveLayer((DataProvider)this.curve, 2));
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                this.curve = new EditableDiscreteDataProvider(points);
                this.curveSlot.setDelegate(new DottedCurveLayer(new DiscreteCurveLayer((DataProvider)this.curve, 0)));
                break;
            }
            case 4: 
            case 6: {
                this.curve = new EditableDiscreteDataProvider(points){

                    @Override
                    public void deletePoint(Coord2D c) {
                        super.deletePoint(c);
                        boolean zero = true;
                        int i = 0;
                        while (i < this.points.size()) {
                            if (this.points.get(i).getY() > 1.0E-5) {
                                zero = false;
                                break;
                            }
                            ++i;
                        }
                        if (zero) {
                            Coord2D last = this.points.getLast();
                            super.deletePoint(last);
                            this.points.add(new Coord2D(last.getX(), 1.0));
                        }
                    }

                    @Override
                    public void replacePoints(Coord2D[] oldPoints, Coord2D[] newPoints) {
                        CurveAreaCompensationHelper compensation = new CurveAreaCompensationHelper(this.points, oldPoints, newPoints);
                        super.replacePoints(compensation.oldPoints, compensation.newPoints);
                    }
                };
                this.curveSlot.setDelegate(new DottedCurveLayer(new DiscreteCurveLayer((DataProvider)this.curve, 0)));
                this.integral.setCurve(this.curve);
            }
        }
        this.redraw();
    }

    public DiscreteIntegral getCurveIntegralCalculator() {
        if (this.type == 4 || this.type == 6) {
            return this.integral;
        }
        throw new RuntimeException("unsupported function called.");
    }

    public void setCurveData(DataProvider provider) {
        this.setCurveData(provider.getPoints());
    }

    public void addDragListener(DragListener listener) {
        this.listener = new DragListenerMulticast(this.listener, listener);
    }

    protected void notifyListenersOnSelect(Coord2D source, int direction) {
        if (this.listener != null) {
            this.listener.onSelect(source, direction);
        }
    }

    protected void notifyListenersOnExecute(Coord2D source, int direction) {
        if (this.listener != null) {
            this.listener.onExecute(source, direction);
        }
    }

    protected void notifyListenersOnPopup(Coord2D source, int direction) {
        if (this.listener != null) {
            this.listener.onPopup(source, direction);
        }
    }

    protected void notifyListenersOnPoint(Coord2D source, int direction) {
        if (this.listener != null) {
            this.listener.onPoint(source, direction);
        }
    }

    protected void notifyListenersOnDrag(Coord2D source, Coord2D target, int direction) {
        if (this.listener != null) {
            this.listener.onDrag(source, target, direction);
        }
    }

    protected void notifyListenersOnDragEnd() {
        if (this.listener != null) {
            this.listener.onDragEnd();
        }
    }
}

