/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.audittrail;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.audittrail.DatabaseFacade;
import org.eclipse.stardust.ide.simulation.ui.audittrail.IAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.IntervalList;
import org.eclipse.stardust.ide.simulation.ui.validation.SimulationFailedException;

public class AppearanceAuditTrailQuery
implements IAuditTrailQuery {
    String sql;
    String objectHint;

    protected AppearanceAuditTrailQuery(String objectHint) {
        this.objectHint = objectHint;
    }

    protected String makePartitionJoin(String schemaPrefix, String partitionId) {
        return StringUtils.isEmpty((String)partitionId) ? "" : " INNER JOIN " + schemaPrefix + "partition R ON R.oid=M.partition and R.id='" + partitionId + "'";
    }

    @Override
    public IntervalList execute(DatabaseFacade database) {
        IntervalList result = new IntervalList();
        try {
            ResultSet rs = database.executeQuery(this.sql);
            if (rs != null) {
                while (rs.next()) {
                    long time = rs.getLong(1);
                    result.add(new Interval(time, 0L));
                }
            }
            database.dispose(rs);
        }
        catch (SQLException e) {
            throw new SimulationFailedException(Simulation_Modeling_Messages.AUDITTRAIL_ERR_SQL, e);
        }
        return result;
    }

    @Override
    public String getObjectHint() {
        return this.objectHint;
    }

    @Override
    public String getSql() {
        return this.sql;
    }
}

