/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.SimulationPlugin;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.IResourceReader;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.ResourceFileDataGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public abstract class ResourceFileDataGenerator
extends RandomDataGenerator {
    public static final String NAME = Simulation_Modeling_Messages.DATA_GENERATOR_FILE;
    public static final String OPTION_FILENAME = "filename";
    public static final String OPTION_WITH_HEADER = "header";
    List data;
    Map reader = new HashMap();
    Random random = new Random(System.currentTimeMillis());

    public abstract Object cast(Object var1);

    public ResourceFileDataGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put(OPTION_FILENAME, "");
        this.options.put(OPTION_WITH_HEADER, "true");
        this.reader.put("text/plain", new IResourceReader.CsvReader());
        this.reader.put("*", this.reader.get("text/plain"));
        this.reader.put(".txt", this.reader.get("text/plain"));
        this.reader.put(".csv", this.reader.get("text/plain"));
        this.reader.put(".dat", this.reader.get("text/plain"));
    }

    @Override
    public Object getRandom() {
        if (this.data == null) {
            String filename = this.getOption(OPTION_FILENAME);
            if (filename != null) {
                IResourceReader reader = this.getReader(filename);
                try {
                    this.data = reader.read(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filename)).getContents());
                    if (this.data.size() > 0 && "true".equals(this.getOption(OPTION_WITH_HEADER))) {
                        this.data.remove(0);
                    }
                    if (this.data.size() == 0) {
                        this.data = null;
                    }
                }
                catch (Exception e) {
                    SimulationPlugin.getDefault().getLog().log((IStatus)new Status(2, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, Simulation_Modeling_Messages.ERROR_IN_DATA_GENERATOR, (Throwable)e));
                }
            } else {
                SimulationPlugin.getDefault().getLog().log((IStatus)new Status(2, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, Simulation_Modeling_Messages.ERROR_IN_DATA_GENERATOR, null));
            }
        }
        try {
            return this.data != null ? this.cast(this.data.get(this.random.nextInt(this.data.size()))) : null;
        }
        catch (RuntimeException e) {
            SimulationPlugin.getDefault().getLog().log((IStatus)new Status(2, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, Simulation_Modeling_Messages.ERROR_IN_DATA_GENERATOR, (Throwable)e));
            return null;
        }
    }

    public IResourceReader getReader(String filename) {
        String key = filename.replaceAll(".*(\\.[^.]+)", "$1");
        if (!this.reader.containsKey(key)) {
            key = "*";
        }
        return (IResourceReader)this.reader.get(key);
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new ResourceFileDataGeneratorPanel(parent, this);
    }

    @Override
    public boolean isComplete() {
        try {
            String filename = this.getOption(OPTION_FILENAME);
            return filename != null && ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filename)).exists();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

