/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import com.gface.date.DatePickerCombo;
import java.util.Date;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.TimestampBaseGenerator;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationDateFormat;
import org.eclipse.stardust.ide.simulation.ui.validation.ValidationUtils;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

public class TimestampBaseGeneratorPanel
extends RandomDataGeneratorPanel {
    LabelWithStatus startPointLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.START_DATE);
    DatePickerCombo startPoint = new DatePickerCombo(this.getInnerBody(), 2048, 1);
    LabelWithStatus endPointLabel;
    DatePickerCombo endPoint;

    protected TimestampBaseGeneratorPanel(Composite parent, TimestampBaseGenerator configuration) {
        super(parent, configuration);
        this.startPoint.setDateFormat(SimulationDateFormat.getInteractiveDateFormatInstance());
        this.startPoint.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        this.startPoint.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TimestampBaseGeneratorPanel.this.verfiyDateValues();
            }
        });
        this.startPoint.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TimestampBaseGeneratorPanel.this.verfiyDateValues();
            }
        });
        this.endPointLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.END_DATE);
        this.endPoint = new DatePickerCombo(this.getInnerBody(), 2048, 1);
        this.endPoint.setDateFormat(SimulationDateFormat.getInteractiveDateFormatInstance());
        this.endPoint.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        this.endPoint.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TimestampBaseGeneratorPanel.this.verfiyDateValues();
            }
        });
        this.endPoint.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TimestampBaseGeneratorPanel.this.verfiyDateValues();
            }
        });
        if (configuration.getOption("startPoint") != null) {
            this.startPoint.setDate(new Date(Long.parseLong(configuration.getOption("startPoint"))));
        }
        if (configuration.getOption("endPoint") != null) {
            this.endPoint.setDate(new Date(Long.parseLong(configuration.getOption("endPoint"))));
        }
        this.verfiyDateValues();
    }

    protected void verfiyDateValues() {
        if (this.startPoint.getDate() == null) {
            this.startPointLabel.setValidationStatus(IQuickValidationStatus.ERRORS);
            this.startPointLabel.setToolTipText(ValidationUtils.format(Simulation_Modeling_Messages.ERROR_VALUE_IS_NOT_VALID, Simulation_Modeling_Messages.START_DATE, this.startPoint.getText()));
        } else {
            this.startPointLabel.setValidationStatus(IQuickValidationStatus.OK);
            this.startPointLabel.setToolTipText(null);
        }
        if (this.endPoint.getDate() == null) {
            this.endPointLabel.setValidationStatus(IQuickValidationStatus.ERRORS);
            this.endPointLabel.setToolTipText(ValidationUtils.format(Simulation_Modeling_Messages.ERROR_VALUE_IS_NOT_VALID, Simulation_Modeling_Messages.END_DATE, this.endPoint.getText()));
        } else {
            this.endPointLabel.setValidationStatus(IQuickValidationStatus.OK);
            this.endPointLabel.setToolTipText(null);
        }
    }

    @Override
    protected void syncUiToModel() {
        if (this.startPoint.getDate() != null) {
            this.configuration.getOptions().put("startPoint", Long.toString(this.startPoint.getDate().getTime()));
        }
        if (this.endPoint.getDate() != null) {
            this.configuration.getOptions().put("endPoint", Long.toString(this.endPoint.getDate().getTime()));
        }
        super.syncUiToModel();
    }
}

