/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.SimulationPlugin;
import org.eclipse.stardust.ide.simulation.ui.distributions.ISimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessForMap;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessForModel;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;

public abstract class AbstractSimulationSubConfiguration
implements ISimulationSubConfiguration {
    boolean isNull = false;
    SimulationInterval interval;

    public AbstractSimulationSubConfiguration(SimulationInterval interval) {
        this.interval = interval;
    }

    @Override
    public SimulationInterval getInterval() {
        return this.interval;
    }

    public void updateInterval(SimulationInterval interval) {
        this.interval = interval;
    }

    @Override
    public void read(IExtensibleElement element, int configurationId) {
        this.read(new AttributeAccessForModel(element, SimulationPlugin.getPrefix(configurationId)));
    }

    @Override
    public void read(Map attributes, int configurationId) {
        this.read(new AttributeAccessForMap(attributes, SimulationPlugin.getPrefix(configurationId)));
    }

    @Override
    public void write(IExtensibleElement element, int configurationId) {
        this.write(new AttributeAccessForModel(element, SimulationPlugin.getPrefix(configurationId)));
    }

    public void write(IExtensibleElement element, int configurationId, boolean withNotification) {
        AttributeAccessForModel wrapper = new AttributeAccessForModel(element, SimulationPlugin.getPrefix(configurationId));
        this.write(wrapper);
        if (withNotification) {
            wrapper.fireNotificationEvent();
        }
    }

    @Override
    public void write(Map attributes, int configurationId) {
        this.write(new AttributeAccessForMap(attributes, SimulationPlugin.getPrefix(configurationId)));
    }

    public void setNull() {
        this.isNull = true;
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    protected void reportConfigurationReadingError(String message, Exception exception) {
        SimulationPlugin.getDefault().getLog().log((IStatus)new Status(4, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, message, (Throwable)exception));
    }
}

