/*******************************************************************************
 * Copyright (c) 2011, 2012 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.stardust.ide.wst.facet.portal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.stardust.ide.wst.common.ExternalLibrary;
import org.eclipse.stardust.ide.wst.common.ILibraryProvider;
import org.eclipse.stardust.ide.wst.common.utils.LibraryProviderUtils;
import org.osgi.framework.BundleContext;


/**
 * @author rsauer
 * @version $Revision: 14628 $
 */
public class IPPPortalBundleActivator extends Plugin implements ILibraryProvider
{
   public static final String BUNDLE_ID = "org.eclipse.stardust.ide.wst.facet.portal"; //$NON-NLS-1$
   public static final String VAR_STARDUST_PORTAL_LIBS = "STARDUST_PORTAL_LIBS"; //$NON-NLS-1$
   private static IPPPortalBundleActivator instance;
   
   public static IPPPortalBundleActivator getInstance()
   {
      return instance;
   }

   public IPPPortalBundleActivator()
   {
      // TODO Auto-generated constructor stub
   }

   public ExternalLibrary resolveExternalLibrary(String jarBaseName)
   {
      return LibraryProviderUtils.resolveExternalLibrary(VAR_STARDUST_PORTAL_LIBS, BUNDLE_ID, jarBaseName);
   }
   
   public void start(BundleContext context) throws Exception
   {
      super.start(context);
      instance = this;
   }

   public void stop(BundleContext context) throws Exception
   {
      instance = null;
      super.stop(context);
   }

   public static void log(final Exception e)
   {
      final String msg = e.getMessage() + ""; //$NON-NLS-1$
      log(new Status(IStatus.ERROR, BUNDLE_ID, IStatus.OK, msg, e));
   }

   public static void log(final IStatus status)
   {
      getInstance().getLog().log(status);
   }

   public static void log(final String msg)
   {
      log(new Status(IStatus.ERROR, BUNDLE_ID, IStatus.OK, msg, null));
   }

   public static IStatus createErrorStatus(final String msg)
   {
      return createErrorStatus(msg, null);
   }

   public static IStatus createErrorStatus(final String msg, final Exception e)
   {
      return new Status(IStatus.ERROR, BUNDLE_ID, 0, msg, e);
   }
}