/*******************************************************************************
 * Copyright (c) 2012 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.stardust.ide.wst.facet.portal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.stardust.ide.wst.common.IModuleConfigurator;
import org.eclipse.stardust.ide.wst.common.IWebModuleConfigurator;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class WebModuleConfigurator implements IWebModuleConfigurator
{
   /* Extension point ID */
   public static final String WEB_MODULE_CONFIGURATOR_ID = "org.eclipse.stardust.ide.wst.facet.portal.webModule"; //$NON-NLS-1$
   
   /* IDs for elements regarding the extension point */
   public static final String INSTALL_CONFIGURATOR_ELEM_ID = "installConfigurator"; //$NON-NLS-1$
   public static final String UNINSTALL_CONFIGURATOR_ELEM_ID = "uninstallConfigurator"; //$NON-NLS-1$
   
   /* Attribute names */
   public static final String CLASS_ATTR_ID = "class"; //$NON-NLS-1$

   private String configuratorType;
   
   public WebModuleConfigurator(String configuratorType)
   {
      if(!INSTALL_CONFIGURATOR_ELEM_ID.equals(configuratorType) &&
            !UNINSTALL_CONFIGURATOR_ELEM_ID.equals(configuratorType))
      {
         throw new IllegalArgumentException("unsupported type of configurator"); //$NON-NLS-1$
      }
      this.configuratorType = configuratorType; 
   }
   
   public void performConfiguration(final ArtifactEdit artifact)
   {
      invokeExtensionPoint(new Callback()
         {
            public void invoke(IModuleConfigurator configurator)
            {
               configurator.performConfiguration(artifact);
            }
         });
   }

   public void performConfiguration(final WebArtifactEdit artifact)
   {
      invokeExtensionPoint(new Callback()
         {
            public void invoke(IModuleConfigurator configurator)
            {
               if(configurator instanceof IWebModuleConfigurator)
               {
                  ((IWebModuleConfigurator)configurator)
                     .performConfiguration(artifact);
               }
            }
         });
   }
   
   private void invokeExtensionPoint(Callback caller)
   {
      IConfigurationElement[] configElems = RegistryFactory.getRegistry()
         .getConfigurationElementsFor(WEB_MODULE_CONFIGURATOR_ID);
      for(IConfigurationElement e : configElems)
      {
         if(this.configuratorType.equals(e.getName()))
         {
            Object o = null;
            try
            {
               o = e.createExecutableExtension(CLASS_ATTR_ID);
               if(o instanceof IModuleConfigurator)
               {
                  caller.invoke((IModuleConfigurator) o);
               }
            }
            catch (CoreException ce)
            {
               ce.printStackTrace();
            }
         }
      }
   }
   
   private interface Callback
   {
      void invoke(IModuleConfigurator configurator);
   }
}
