/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.generation;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.StructuredTypeRtUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSFPlugin;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSF_Messages;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.GenericDataMapping;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.StructuredDataPanelGenerator;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.osgi.framework.Bundle;

public class JSFPanelGenerator {
    private static final String FACES_CONFIG = "<faces-config>";
    private static final String FACES_CONFIG_END = "</faces-config>";
    private static final String MSG_SAME_ID_DIFF_MAPPING = JSF_Messages.MSG_SameIdForDiffMappings;
    static final String SEP = System.getProperty("line.separator");
    private static final String[] stylesheets = new String[]{"nirvanaRime", "nirvanaRime-override", "nirvanaPortal", "portalComponentStyle", "alerts"};

    public static String generateXHTMLForJsfActivity(List<GenericDataMapping> dataMappings, String beanName) {
        StringBuffer xml = new StringBuffer();
        JSFPanelGenerator.createHtmlPage(xml, dataMappings, beanName);
        return xml.toString();
    }

    private static void createHtmlPage(StringBuffer xml, List<GenericDataMapping> dataMappings, String beanName) {
        xml.append("<ice:outputHtml xmlns:ice=\"http://www.icesoft.com/icefaces/component\"").append(SEP).append("                xmlns:h=\"http://java.sun.com/jsf/html\"").append(SEP).append("                xmlns:f=\"http://java.sun.com/jsf/core\">").append(SEP);
        JSFPanelGenerator.createHeader(xml);
        JSFPanelGenerator.createBody(xml, dataMappings, beanName);
        xml.append("</ice:outputHtml>").append(SEP);
    }

    private static void createHeader(StringBuffer xml) {
        xml.append("  <ice:outputHead>").append(SEP);
        int i = 0;
        while (i < stylesheets.length) {
            xml.append("    <ice:outputStyle href=\"/plugins/common/css/" + stylesheets[i] + ".css\"/>").append(SEP);
            ++i;
        }
        xml.append("    </ice:outputHead>").append(SEP);
    }

    private static void createBody(StringBuffer xml, List<GenericDataMapping> dataMappings, String beanName) {
        xml.append("  <ice:outputBody>").append(SEP).append("    <ice:form id=\"ipp_form\">").append(SEP).append("      <h:panelGrid id=\"data_mappings\" columns=\"2\" styleClass=\"table-form\" columnClasses=\"table-label-column,table-component-column\">").append(SEP);
        JSFPanelGenerator.createBodyForDataMappings(xml, dataMappings, beanName);
        xml.append("      </h:panelGrid>").append(SEP).append("    </ice:form>").append(SEP).append("  </ice:outputBody>").append(SEP);
    }

    private static void createBodyForDataMappings(StringBuffer xml, List<GenericDataMapping> dataMappings, String beanName) {
        String id;
        Map inDataMappings = CollectionUtils.newMap();
        Map outDataMappings = CollectionUtils.newMap();
        for (GenericDataMapping genericDataMapping : dataMappings) {
            id = genericDataMapping.getId();
            switch (genericDataMapping.getDataMapping().getDirection()) {
                case OUT_LITERAL: {
                    GenericDataMapping inDataMapping = (GenericDataMapping)inDataMappings.get(id);
                    if (inDataMapping != null) {
                        if (!inDataMapping.getMappedType().getMappedType().equals(genericDataMapping.getMappedType().getMappedType())) {
                            throw new RuntimeException(MSG_SAME_ID_DIFF_MAPPING);
                        }
                        inDataMappings.remove(inDataMapping.getId());
                    }
                    outDataMappings.put(id, genericDataMapping);
                    break;
                }
                case IN_LITERAL: {
                    GenericDataMapping outDataMapping = (GenericDataMapping)outDataMappings.get(id);
                    if (outDataMapping == null) {
                        inDataMappings.put(id, genericDataMapping);
                        break;
                    }
                    if (outDataMapping.getMappedType().getMappedType().equals(genericDataMapping.getMappedType().getMappedType())) break;
                    throw new RuntimeException(MSG_SAME_ID_DIFF_MAPPING);
                }
            }
        }
        for (GenericDataMapping genericDataMapping : dataMappings) {
            id = genericDataMapping.getId();
            if (inDataMappings.containsKey(id)) {
                JSFPanelGenerator.generateDataGroup(xml, genericDataMapping, beanName, true);
                inDataMappings.remove(id);
                continue;
            }
            if (!outDataMappings.containsKey(id)) continue;
            JSFPanelGenerator.generateDataGroup(xml, genericDataMapping, beanName, false);
            outDataMappings.remove(id);
        }
    }

    private static void generateDataGroup(StringBuffer xml, GenericDataMapping mapping, String beanName, boolean readOnly) {
        xml.append("        <ice:outputText value=\"").append(mapping.getLabel()).append(":\"/>").append(SEP);
        Class<?> mappedType = mapping.getMappedType().getMappedType();
        switch (mapping.getControlType()) {
            case 4: {
                JSFPanelGenerator.generateInputText(xml, mapping, beanName, readOnly);
                break;
            }
            case 3: {
                JSFPanelGenerator.generateCheckBox(xml, mapping, beanName, readOnly);
                break;
            }
            case 2: {
                JSFPanelGenerator.generateButtons(xml, mapping, beanName, readOnly);
                break;
            }
            case 1: {
                JSFPanelGenerator.generateComboBox(xml, mapping, beanName, readOnly);
                break;
            }
            case 0: {
                if (Boolean.class.equals(mappedType)) {
                    JSFPanelGenerator.generateCheckBox(xml, mapping, beanName, readOnly);
                    break;
                }
                if (Date.class.equals(mappedType) || Calendar.class.equals(mappedType)) {
                    if (StructuredTypeRtUtils.isDmsType((String)mapping.getDataMapping().getData().getType().getId()) || StructuredTypeRtUtils.isStructuredType((String)mapping.getDataMapping().getData().getType().getId())) {
                        String xPath;
                        IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((DataType)mapping.getDataMapping().getData());
                        if (xPathMap.getXPath(xPath = StructuredDataXPathUtils.getXPathWithoutIndexes((String)mapping.getDataMapping().getDataPath())).getXsdTypeName().equals("time")) {
                            JSFPanelGenerator.generateInputDate(xml, mapping, beanName, readOnly, "time");
                            break;
                        }
                        JSFPanelGenerator.generateInputDate(xml, mapping, beanName, readOnly, "both");
                        break;
                    }
                    JSFPanelGenerator.generateInputDate(xml, mapping, beanName, readOnly, "both");
                    break;
                }
                if (List.class.equals(mappedType) || Map.class.equals(mappedType)) {
                    JSFPanelGenerator.generateStructured(xml, mapping, beanName, readOnly);
                    break;
                }
                JSFPanelGenerator.generateInputText(xml, mapping, beanName, readOnly);
                break;
            }
            default: {
                JSFPanelGenerator.generateInputText(xml, mapping, beanName, readOnly);
            }
        }
    }

    private static void generateStructured(StringBuffer xml, GenericDataMapping mapping, String beanName, boolean readOnly) {
        try {
            StringBuffer sb = new StringBuffer();
            String wrapperVariableName = String.valueOf(beanName) + "." + mapping.getPropertyName() + "Wrapper";
            StructuredDataPanelGenerator structuredDataPanelGenerator = new StructuredDataPanelGenerator("        ", mapping, wrapperVariableName, readOnly);
            structuredDataPanelGenerator.createPanel(sb);
            xml.append(sb);
        }
        catch (Exception ex) {
            JSFPlugin plugin = JSFPlugin.getDefault();
            Bundle bundle = plugin.getBundle();
            String name = bundle.getSymbolicName();
            ErrorDialog.openError(null, (String)"JSF Panel", (String)("Skipping data mapping: " + mapping.getId()), (IStatus)new Status(2, name, ex.getMessage()));
        }
    }

    private static void generateButtons(StringBuffer xml, GenericDataMapping mapping, String beanName, boolean readOnly) {
        xml.append("        <ice:panelLayout layout=\"flow\">").append("<ice:commandButton disabled=\"").append(readOnly).append("\" value=\"").append("Yes").append("\" action=\"#{").append(beanName).append(".").append(mapping.getBooleanMethodName(true)).append("}\" style=\"width:50px\"/>").append("<ice:commandButton disabled=\"").append(readOnly).append("\" value=\"").append("No").append("\" action=\"#{").append(beanName).append(".").append(mapping.getBooleanMethodName(false)).append("}\" inlineStyle=\"width:50px\"/>").append("</ice:panelLayout>").append(SEP);
    }

    private static void generateComboBox(StringBuffer xml, GenericDataMapping mapping, String beanName, boolean readOnly) {
        String dataPath;
        IXPathMap xPathMap;
        TypedXPath typedXPath;
        xml.append("        <ice:selectOneMenu disabled=\"").append(readOnly).append("\" id=\"").append(mapping.getId()).append("\" value=\"#{").append(beanName).append(".").append(mapping.getPropertyName()).append("}\">").append(SEP);
        xml.append("          <f:selectItem itemLabel=\"\" itemValue=\"\"/>").append(SEP);
        DataType data = mapping.getDataMapping().getData();
        if ("struct".equals(data.getType().getId()) && (typedXPath = (xPathMap = StructuredTypeUtils.getXPathMap((DataType)data)).getXPath((dataPath = mapping.getDataMapping().getDataPath()) == null ? "" : dataPath)).isEnumeration()) {
            List enumerationValues = typedXPath.getEnumerationValues();
            for (Object value : enumerationValues) {
                xml.append("          <f:selectItem itemLabel=\"").append(value.toString()).append("\" itemValue=\"").append(value.toString()).append("\"/>").append(SEP);
            }
        }
        xml.append("        </ice:selectOneMenu>").append(SEP);
    }

    private static void generateCheckBox(StringBuffer xml, GenericDataMapping mapping, String beanName, boolean readOnly) {
        xml.append("        <ice:selectBooleanCheckbox disabled=\"").append(readOnly).append("\" id=\"").append(mapping.getId()).append("\" value=\"#{").append(beanName).append(".").append(mapping.getPropertyName()).append("}\"/>").append(SEP);
    }

    private static void generateInputText(StringBuffer xml, GenericDataMapping mapping, String beanName, boolean readOnly) {
        xml.append("        <ice:inputText readonly=\"").append(readOnly).append("\" id=\"").append(mapping.getId()).append("\" value=\"#{").append(beanName).append(".").append(mapping.getPropertyName()).append("}\"");
        if (mapping.isNumber()) {
            xml.append("><f:convertNumber locale=\"en\"");
            if (mapping.isInteger()) {
                xml.append(" integerOnly=\"true\"");
            }
            xml.append("/></ice:inputText>");
        } else {
            if (mapping.getMappedType().getMappedType() == Character.class) {
                xml.append(" maxlength=\"1\"");
            }
            xml.append("/>");
        }
        xml.append(SEP);
    }

    private static void generateInputDate(StringBuffer xml, GenericDataMapping mapping, String beanName, boolean readOnly, String type) {
        xml.append("        <ice:selectInputDate disabled=\"").append(readOnly).append("\" id=\"").append(mapping.getId()).append("\" renderAsPopup=\"true\" value=\"#{").append(beanName).append(".").append(mapping.getPropertyName()).append("}\"><f:convertDateTime locale=\"en\" type=\"").append(type).append("\"/></ice:selectInputDate>").append(SEP);
    }

    public static String generateXMLForFaces(String name, String beanClassName, String context) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n").append("<!DOCTYPE faces-config PUBLIC\n").append("    \"-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN\"\n").append("    \"http://java.sun.com/dtd/web-facesconfig_1_1.dtd\">\n");
        JSFPanelGenerator.updateXMLForFaces(xml, name, beanClassName, context);
        return xml.toString();
    }

    public static String updateXMLForFaces(StringBuffer sb, String name, String beanClassName, String context) {
        StringBuffer text = new StringBuffer();
        text.append("<managed-bean>\n").append("        <managed-bean-name>").append(name).append("</managed-bean-name>\n").append("        <managed-bean-class>").append(beanClassName).append("</managed-bean-class>\n").append("        <managed-bean-scope>").append(context).append("</managed-bean-scope>\n").append("    </managed-bean>");
        int facesConfigStart = sb.indexOf(FACES_CONFIG);
        if (facesConfigStart < 0) {
            sb.append(FACES_CONFIG).append("\n    ").append(text).append('\n').append(FACES_CONFIG_END).append("\n");
        } else {
            boolean replaced = false;
            int managedBeanStart = sb.indexOf("<managed-bean>", facesConfigStart += FACES_CONFIG.length());
            int managedBeanEnd = sb.indexOf("</managed-bean>", managedBeanStart);
            while (managedBeanStart >= 0) {
                int managedBeanNameStart = sb.indexOf("<managed-bean-name>", managedBeanStart);
                int managedBeanNameEnd = sb.indexOf("</managed-bean-name>", managedBeanNameStart);
                String beanName = sb.substring(managedBeanNameStart + "<managed-bean-name>".length(), managedBeanNameEnd).trim();
                if (name.equals(beanName)) {
                    sb.replace(managedBeanStart, managedBeanEnd + "</managed-bean>".length(), text.toString());
                    replaced = true;
                    break;
                }
                managedBeanStart = sb.indexOf("<managed-bean>", managedBeanEnd);
                managedBeanEnd = sb.indexOf("</managed-bean>", managedBeanStart);
            }
            if (!replaced) {
                sb.insert(facesConfigStart, "\n    " + text + '\n');
            }
        }
        return sb.toString();
    }

    public static String getUrlType() {
        return "iface";
    }

    public static String getResourceType() {
        return "xhtml";
    }
}

