/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.generation;

import java.util.Calendar;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import org.eclipse.stardust.ui.common.form.Indent;
import org.eclipse.stardust.ui.common.form.jsf.JsfFormGenerator;
import org.eclipse.stardust.ui.common.form.preferences.FormGenerationPreferences;
import org.eclipse.stardust.ui.common.introspection.Path;
import org.eclipse.stardust.ui.web.common.util.CustomBooleanConverter;
import org.eclipse.stardust.ui.web.common.util.CustomDateConverter;
import org.eclipse.stardust.ui.web.common.util.CustomDateTimeConverter;
import org.eclipse.stardust.ui.web.common.util.CustomTimeConverter;
import org.eclipse.stardust.ui.web.viewscommon.common.converter.PriorityConverter;
import org.eclipse.stardust.ui.web.viewscommon.utils.IceFacesHelperExt;

public class ManualActivityJsfFormGenerator
extends JsfFormGenerator {
    public ManualActivityJsfFormGenerator(FormGenerationPreferences generationPreferences, String formBinding) {
        super(generationPreferences, formBinding);
    }

    public String getBindingValue(Path path, String value) {
        if ("value".equals(value) && !"/PROCESS_PRIORITY".equals(path.getFullXPath())) {
            return "." + this.convertFullXpathToMapNotationForBinding(path);
        }
        return super.getBindingValue(path, value);
    }

    protected Converter getConverter(Path path) {
        Converter converter = ManualActivityJsfFormGenerator.getCustomConverter(path);
        if (converter != null) {
            return converter;
        }
        return super.getConverter(path);
    }

    private static Converter getCustomConverter(Path path) {
        PriorityConverter converter = null;
        if ("PROCESS_PRIORITY".equals(path.getId())) {
            converter = new PriorityConverter();
        } else if (path.getJavaClass().equals(Boolean.class) || path.getJavaClass().equals(Boolean.TYPE)) {
            converter = new CustomBooleanConverter();
        } else if (path.getJavaClass().equals(Date.class) || path.getJavaClass().equals(Calendar.class)) {
            if ("date".equals(path.getTypeName())) {
                return new CustomDateConverter();
            }
            if ("time".equals(path.getTypeName())) {
                return new CustomTimeConverter();
            }
            return new CustomDateTimeConverter();
        }
        return converter;
    }

    private String convertFullXpathToMapNotationForBinding(Path path) {
        StringBuffer sb = new StringBuffer();
        String[] allXPaths = path.getFullXPath().substring(1).split("/");
        if (allXPaths[0].length() > 1 && Character.isUpperCase(allXPaths[0].charAt(1))) {
            sb.append(allXPaths[0]);
        } else {
            sb.append(allXPaths[0].substring(0, 1).toLowerCase()).append(allXPaths[0].substring(1));
        }
        if (path.isPrimitive() && Calendar.class == path.getJavaClass()) {
            sb.append("AsDate");
        }
        if (allXPaths.length > 1) {
            int i = 1;
            while (i < allXPaths.length) {
                sb.append("['").append(allXPaths[i]).append("']");
                ++i;
            }
        }
        return sb.toString();
    }

    public String generateMarkup(UIComponent comp, Indent indent) {
        return new IceFacesHelperExt().generateMarkup(comp, indent == null ? new Indent() : indent);
    }
}

