/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.generation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.api.runtime.Document;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.GenericDataMapping;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.ManualActivityForm;
import org.eclipse.stardust.ui.common.form.Indent;
import org.eclipse.stardust.ui.common.form.preferences.FormGenerationPreferences;

public class ManualActivityToJsfConverter {
    public static final String CALENDAR_METHOD_SUFFIX = "AsDate";
    private static final String SEP = System.getProperty("line.separator");
    private static final String[] styleSheets = new String[]{"/plugins/common/css/nirvanaRime.css", "/plugins/common/css/nirvanaRime-override.css", "/plugins/common/css/nirvanaPortal.css", "/plugins/common/css/portalComponentStyle.css", "/plugins/stardust-ui-form-jsf/public/css/stardust-ui-form-jsf.css", "/plugins/processportal/css/stardust-ui-form-jsf-override.css"};

    public static String generateBeanForJsfActivity(List<GenericDataMapping> dataMappings, String packageName, String className) {
        StringBuffer markup = new StringBuffer();
        HashSet<String> imports = new HashSet<String>();
        StringBuffer completeMetodLines = new StringBuffer();
        String accessMethods = ManualActivityToJsfConverter.generateAccessMethods(dataMappings, imports, completeMetodLines);
        markup.append("package ").append(packageName).append(";\n\n");
        imports.add("import org.eclipse.stardust.ui.web.processportal.view.jsfconversion.JsfActivityPanelBean;");
        imports.add("import org.eclipse.stardust.ui.web.common.log.LogManager;");
        imports.add("import org.eclipse.stardust.ui.web.common.log.Logger;");
        ArrayList<String> sortedImports = new ArrayList<String>(imports);
        Collections.sort(sortedImports, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareTo(arg1);
            }
        });
        for (String imprt : sortedImports) {
            markup.append(imprt).append("\n");
        }
        markup.append("\n");
        markup.append("@SuppressWarnings({\"rawtypes\", \"unused\", \"unchecked\"})\n");
        markup.append("public class ").append(className).append(" extends JsfActivityPanelBean").append(" {\n\n");
        markup.append("\tprivate static final Logger trace = LogManager.getLogger(" + className + ".class);\n\n");
        markup.append("\tpublic void complete() {").append(completeMetodLines).append("\n\t}");
        markup.append(accessMethods).append("\n");
        markup.append("}");
        return markup.toString();
    }

    private static String generateAccessMethods(List<GenericDataMapping> dataMappings, Set<String> imports, StringBuffer completeMetodLines) {
        StringBuffer sb = new StringBuffer();
        List cache = CollectionUtils.newList();
        for (GenericDataMapping mapping : dataMappings) {
            Class<?> type = mapping.getMappedType().getMappedType();
            String name = mapping.getId();
            if (cache.contains(name)) continue;
            if (!type.getName().startsWith("java.lang.")) {
                imports.add("import " + type.getName() + ";");
                if (Calendar.class == type) {
                    imports.add("import java.util.Date;");
                }
            }
            if (type == Map.class || type == List.class) {
                sb.append(ManualActivityToJsfConverter.generateGetterSetterForStruct(mapping.getId(), type, completeMetodLines));
            } else if ("PROCESS_PRIORITY".equals(mapping.getDataMapping().getData().getId())) {
                sb.append(ManualActivityToJsfConverter.generateGetterSetterForProcessPriority(mapping.getId(), type, completeMetodLines));
            } else {
                sb.append(ManualActivityToJsfConverter.generateGetterSetter(mapping.getId(), type, completeMetodLines));
            }
            cache.add(name);
        }
        return sb.toString();
    }

    private static String generateGetterSetter(String variableName, Class<?> type, StringBuffer completeMetodLines) {
        StringBuffer sb = new StringBuffer();
        if (Calendar.class == type) {
            String getterCalendar1 = "\n\n\tpublic Calendar get<VariableName>() {\n\t\treturn (Calendar)getDataAsCalendar(\"<VariableName>\");\n\t}";
            String setterCalendar1 = "\n\tpublic void set<VariableName>(Calendar <VariableName>) {\n\t\tsetData(\"<VariableName>\", <VariableName>);\n\t}";
            String getterCalendar2 = "\n\tpublic Date get<VariableName>AsDate() {\n\t\treturn (Date)getDataAsDate(\"<VariableName>\");\n\t}";
            String setterCalendar2 = "\n\tpublic void set<VariableName>AsDate(Date <VariableName>) {\n\t\tsetData(\"<VariableName>\", <VariableName>);\n\t}";
            sb.append(getterCalendar1.replaceAll("<VariableName>", variableName));
            sb.append(setterCalendar1.replaceAll("<VariableName>", variableName));
            sb.append(getterCalendar2.replaceAll("<VariableName>", variableName));
            sb.append(setterCalendar2.replaceAll("<VariableName>", variableName));
        } else {
            String getter = "\n\n\tpublic <Type> get<VariableName>() {\n\t\treturn (<Type>)getData(\"<VariableName>\");\n\t}";
            String setter = "\n\tpublic void set<VariableName>(<Type> <VariableName>) {\n\t\tsetData(\"<VariableName>\", <VariableName>);\n\t}";
            String completeMethodCodeForDoc = "\n\t\tsaveDocumentIfRequired(\"<VariableName>\");";
            sb.append(getter.replaceAll("<VariableName>", variableName).replaceAll("<Type>", type.getSimpleName()));
            sb.append(setter.replaceAll("<VariableName>", variableName).replaceAll("<Type>", type.getSimpleName()));
            if (Document.class == type) {
                completeMetodLines.append(completeMethodCodeForDoc.replaceAll("<VariableName>", variableName));
            }
        }
        return sb.toString();
    }

    private static String generateGetterSetterForStruct(String variableName, Class<?> type, StringBuffer completeMetodLines) {
        String variable = "\n\n\tprivate <Type> <VariableName>;";
        String getter = "\n\tpublic <Type> get<VariableName>() {\n\t\tif (null == <VariableName>) {\n\t\t\t<VariableName> = (<Type>)getData(\"<VariableName>\");\n\t\t}\n\t\treturn <VariableName>;\n\t}";
        String setter = "\n\tpublic void set<VariableName>(<Type> <VariableName>) {\n\t\tsetData(\"<VariableName>\", <VariableName>);\n\t}";
        String completeMethodCode = "\n\t\tmergeDataForList(<VariableName>, (Map)getData(\"<VariableName>\"));";
        StringBuffer sb = new StringBuffer();
        sb.append(variable.replaceAll("<VariableName>", variableName).replaceAll("<Type>", type.getSimpleName()));
        sb.append(getter.replaceAll("<VariableName>", variableName).replaceAll("<Type>", type.getSimpleName()));
        sb.append(setter.replaceAll("<VariableName>", variableName).replaceAll("<Type>", type.getSimpleName()));
        if (Map.class == type) {
            completeMetodLines.append(completeMethodCode.replaceAll("<VariableName>", variableName));
        }
        return sb.toString();
    }

    private static String generateGetterSetterForProcessPriority(String variableName, Class<?> type, StringBuffer completeMetodLines) {
        StringBuffer sb = new StringBuffer();
        String getterCalendar = "\n\n\tpublic Integer get<VariableName>() {\n\t\treturn getDataAsPriorityIndex(\"<VariableName>\");\n\t}";
        String setterCalendar = "\n\tpublic void set<VariableName>(Integer <VariableName>) {\n\t\tsetData(\"<VariableName>\", <VariableName>);\n\t}";
        sb.append(getterCalendar.replaceAll("<VariableName>", variableName));
        sb.append(setterCalendar.replaceAll("<VariableName>", variableName));
        return sb.toString();
    }

    public static String generateXHTMLForJsfActivity(List<GenericDataMapping> dataMappings, String beanName, FormGenerationPreferences genPrefs) {
        ManualActivityForm form = new ManualActivityForm(dataMappings, beanName, genPrefs);
        StringBuffer markup = new StringBuffer();
        ManualActivityToJsfConverter.createHtmlPage(markup, form);
        return markup.toString();
    }

    private static void createHtmlPage(StringBuffer markup, ManualActivityForm form) {
        markup.append("<ice:outputHtml xmlns:ice=\"http://www.icesoft.com/icefaces/component\"").append(SEP).append("                xmlns:h=\"http://java.sun.com/jsf/html\"").append(SEP).append("                xmlns:f=\"http://java.sun.com/jsf/core\">").append(SEP);
        ManualActivityToJsfConverter.createHeader(markup);
        ManualActivityToJsfConverter.createBody(markup, form);
        markup.append("</ice:outputHtml>").append(SEP);
    }

    private static void createHeader(StringBuffer markup) {
        markup.append("  <ice:outputHead>").append(SEP);
        int i = 0;
        while (i < styleSheets.length) {
            markup.append("    <ice:outputStyle href=\"" + styleSheets[i] + "\"/>").append(SEP);
            ++i;
        }
        markup.append("  </ice:outputHead>").append(SEP);
    }

    private static void createBody(StringBuffer markup, ManualActivityForm form) {
        markup.append("  <ice:outputBody>").append(SEP).append("    <ice:form id=\"#{" + form.getBeanName() + ".formId" + "}\">");
        markup.append(form.generateMarkup(new Indent(2))).append(SEP);
        markup.append("    </ice:form>").append(SEP).append("  </ice:outputBody>").append(SEP);
    }
}

