/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.wizard;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stardust.common.reflect.MethodDescriptor;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSF_Messages;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.GenericDataMapping;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.wizard.JSFGuiGenerationWizardPage1;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.wizard.JSFGuiGenerationWizardPage2;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.ActivitySymbolNodeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.utils.MetaTypeModelingUtils;
import org.eclipse.stardust.ui.common.form.preferences.FormGenerationPreferences;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class JSFGuiGenerationWizard
extends Wizard
implements IWizard {
    private JSFGuiGenerationWizardPage1 page1;
    private JSFGuiGenerationWizardPage2 page2;
    private ActivityType activity;
    private ActivitySymbolType activitySymbol;
    private Map<?, ?> registry;
    private List<GenericDataMapping> genericDataMappings;
    private WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();

    public JSFGuiGenerationWizard(ActivityType activity, ActivitySymbolType symbol, Map<?, ?> registry) {
        this.activity = activity;
        this.activitySymbol = symbol;
        this.registry = registry;
        if (activity != null) {
            this.genericDataMappings = GenericDataMapping.generateGenericDataMappingFromDataMappings((List<DataMappingType>)activity.getDataMapping());
        }
        this.setWindowTitle(JSF_Messages.JSFGuiGenerationWizard_Title);
    }

    public boolean performFinish() {
        List<GenericDataMapping> dataMappings = this.genericDataMappings;
        int numberOfColumnsInColumnLayout = this.page2.getNumberOfColumnsInColumnLayout();
        FormGenerationPreferences genPrefs = new FormGenerationPreferences(numberOfColumnsInColumnLayout, 0);
        try {
            this.page1.createResources(dataMappings, genPrefs);
        }
        catch (CoreException ex) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JSF_Messages.JSFGuiGenerationWizard_FatalError, (String)JSF_Messages.JSFGuiGenerationWizard_CannotCreateResources, (IStatus)ex.getStatus());
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            ErrorDialog.openError((Shell)this.getShell(), (String)JSF_Messages.JSFGuiGenerationWizard_FatalError, (String)JSF_Messages.JSFGuiGenerationWizard_CannotCreateResources, (IStatus)new StatusInfo(4, JSF_Messages.JSFGuiGenerationWizard_CannotCreateResourcesUnknown));
            return false;
        }
        if (this.activity != null && ActivityImplementationType.MANUAL_LITERAL.equals((Object)this.activity.getImplementation())) {
            ModelType model = ModelUtils.findContainingModel((EObject)this.activity);
            ApplicationContextTypeType jsfContext = ModelUtils.getApplicationContextType((IModelElement)this.activity, (String)"jsf");
            if (jsfContext == null) {
                IConfigurationElement config = MetaTypeModelingUtils.getApplicationContextExtension((String)"jsf");
                if (config != null) {
                    CreateMetaTypeCommand createContextTypeCmd = MetaTypeModelingUtils.getCreateContextTypeCmd((IConfigurationElement)config);
                    createContextTypeCmd.setParent((EObject)this.activity);
                    createContextTypeCmd.execute();
                }
                jsfContext = ModelUtils.getApplicationContextType((IModelElement)this.activity, (String)"jsf");
            }
            if (jsfContext != null) {
                Object ep;
                ContextType context = CarnotWorkflowModelFactory.eINSTANCE.createContextType();
                context.setType(jsfContext);
                ApplicationType app = CarnotWorkflowModelFactory.eINSTANCE.createApplicationType();
                String applicationName = this.page1.getApplicationName();
                String applicationId = "";
                if (applicationName == null || applicationName.equals("")) {
                    applicationName = String.valueOf(this.activity.getName()) + " App";
                    applicationId = String.valueOf(this.activity.getId()) + "_App";
                } else {
                    applicationId = applicationName.replace(' ', '_');
                }
                IdFactory idFactory = new IdFactory(applicationId, applicationName);
                idFactory.computeNames((List)model.getApplication(), false);
                app.setId(idFactory.getId());
                app.setName(idFactory.getName());
                app.setInteractive(true);
                AttributeUtil.setAttribute((IExtensibleElement)context, (String)"jsf:componentKind", (String)"facelets");
                AttributeUtil.setAttribute((IExtensibleElement)context, (String)"jsf:url", (String)this.page1.getPageUrl());
                AttributeUtil.setAttribute((IExtensibleElement)context, (String)"jsf:managedBeanName", (String)this.page1.getBeanName());
                AttributeUtil.setAttribute((IExtensibleElement)context, (String)"carnot:engine:className", (String)this.page1.getAdapterClass());
                AttributeUtil.setAttribute((IExtensibleElement)context, (String)"carnot:engine:methodName", (String)"complete()");
                model.getApplication().add((Object)app);
                app.getContext().add((Object)context);
                this.activity.setImplementation(ActivityImplementationType.APPLICATION_LITERAL);
                this.activity.setApplication(app);
                this.updateDataMappings(dataMappings);
                if (this.activitySymbol != null && (ep = this.registry.get(this.activitySymbol)) instanceof ActivitySymbolNodeEditPart) {
                    IFigure figActivity;
                    Dimension szActivity;
                    DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)this.activitySymbol);
                    PoolSymbol pool = DiagramUtil.getDefaultPool((DiagramType)diagram);
                    Object container = pool == null ? diagram : (ISymbolContainer)this.activitySymbol.eContainer();
                    ApplicationSymbolType applicationSymbol = this.createApplicationSymbol((ISymbolContainer)this.activitySymbol.eContainer(), new Point((double)this.activitySymbol.getXPos(), (double)this.activitySymbol.getYPos()), this.activity.getApplication());
                    this.createApplicationConnection((ISymbolContainer)container, this.activitySymbol, applicationSymbol);
                    GraphicalEditPart epApplication = (GraphicalEditPart)this.registry.get(applicationSymbol);
                    long xPos = this.activitySymbol.getXPos();
                    long yPos = this.activitySymbol.getYPos();
                    IFigure figApplication = epApplication.getFigure();
                    Dimension szApplication = figApplication.getSize();
                    if (szApplication.isEmpty()) {
                        szApplication = figApplication.getPreferredSize();
                    }
                    if ((szActivity = (figActivity = ((ActivitySymbolNodeEditPart)ep).getFigure()).getSize()).isEmpty()) {
                        szActivity = figActivity.getPreferredSize();
                    }
                    Point point = new Point((int)xPos, (int)yPos);
                    Point emptyLocation = this.getEmptyLocation(szActivity, szApplication, point);
                    applicationSymbol.setXPos((long)emptyLocation.x);
                    applicationSymbol.setYPos((long)emptyLocation.y);
                }
            }
        }
        return true;
    }

    private Point getEmptyLocation(Dimension szActivity, Dimension szApplication, Point point) {
        Point startPoint = point.getCopy();
        int maxCnt = 40;
        int state = 1;
        int spacex = 5;
        int spacey = 5;
        int startCntX = 2;
        int startCntY = 2;
        int xcounter = 1;
        int ycounter = 1;
        int i = 0;
        while (i < maxCnt) {
            switch (state) {
                case 1: {
                    int cnt = startCntX + xcounter;
                    int startx = startPoint.x - szActivity.width / 2 - (szApplication.width / 2 + spacex) * xcounter;
                    int starty = startPoint.y + szActivity.height / 2 + (szApplication.height / 2 + spacey) * ycounter;
                    int c = 0;
                    while (c < cnt) {
                        point.x = startx + c * (szApplication.width + spacex);
                        point.y = starty;
                        if (this.checkValidPoint(point) && this.checkValidSpace(point, szApplication)) {
                            return point;
                        }
                        ++c;
                    }
                    state = 2;
                    break;
                }
                case 2: {
                    int cnt = startCntY + ycounter;
                    int startx = startPoint.x + szActivity.width / 2 + (szApplication.width / 2 + spacex) * xcounter;
                    int starty = startPoint.y + szActivity.height / 2 + (szApplication.height / 2 + spacey) * ycounter;
                    int c = 0;
                    while (c < cnt) {
                        point.x = startx;
                        point.y = starty - c * (szApplication.height + spacey);
                        if (this.checkValidPoint(point) && this.checkValidSpace(point, szApplication)) {
                            return point;
                        }
                        ++c;
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    int cnt = startCntX + xcounter;
                    int startx = startPoint.x + szActivity.width / 2 + (szApplication.width / 2 + spacex) * xcounter;
                    int starty = startPoint.y - szActivity.height / 2 - (szApplication.height / 2 + spacey) * ycounter;
                    int c = 0;
                    while (c < cnt) {
                        point.x = startx - c * (szApplication.width + spacex);
                        point.y = starty;
                        if (this.checkValidPoint(point) && this.checkValidSpace(point, szApplication)) {
                            return point;
                        }
                        ++c;
                    }
                    state = 4;
                    break;
                }
                case 4: {
                    int cnt = startCntY + ycounter;
                    int startx = startPoint.x - szActivity.width / 2 - (szApplication.width / 2 + spacex) * xcounter;
                    int starty = startPoint.y - szActivity.height / 2 - (szApplication.height / 2 + spacey) * ycounter;
                    int c = 0;
                    while (c < cnt) {
                        point.x = startx;
                        point.y = starty + c * (szApplication.height + spacey);
                        if (this.checkValidPoint(point) && this.checkValidSpace(point, szApplication)) {
                            return point;
                        }
                        ++c;
                    }
                    ++xcounter;
                    ++ycounter;
                    state = 1;
                }
            }
            ++i;
        }
        return point;
    }

    private boolean checkValidSpace(Point point, Dimension dimension) {
        Rectangle checkRectangle = new Rectangle(point, dimension);
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)this.activitySymbol);
        PoolSymbol pool = DiagramUtil.getDefaultPool((DiagramType)diagram);
        Object container = !diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) ? diagram : (pool == null ? diagram : (ISymbolContainer)this.activitySymbol.eContainer());
        EditPart host = this.editor.findEditPart(container);
        IFigure hostFigure = ((AbstractGraphicalEditPart)host).getFigure();
        List children = hostFigure.getChildren();
        for (IFigure childFigure : children) {
            Rectangle targetBounds = childFigure.getBounds();
            if (!targetBounds.intersects(checkRectangle)) continue;
            return false;
        }
        return true;
    }

    private boolean checkValidPoint(Point point) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)this.activitySymbol);
        PoolSymbol pool = DiagramUtil.getDefaultPool((DiagramType)diagram);
        Object container = !diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) ? diagram : (pool == null ? diagram : (ISymbolContainer)this.activitySymbol.eContainer());
        EditPart host = this.editor.findEditPart(container);
        IFigure hostFigure = ((AbstractGraphicalEditPart)host).getFigure();
        Dimension hostDimension = hostFigure.getSize();
        if (point.x <= 0) {
            return false;
        }
        if (point.y <= 0) {
            return false;
        }
        if (host instanceof AbstractSwimlaneEditPart) {
            return true;
        }
        if (point.x >= hostDimension.width) {
            return false;
        }
        return point.y < hostDimension.height;
    }

    private ApplicationSymbolType createApplicationSymbol(ISymbolContainer container, Point position, ApplicationType application) {
        IdFactory id = new IdFactory("Symbol", JSF_Messages.BASENAME_Symbol, (IIdentifiableModelElement)application);
        CreateSymbolCommand cmd = new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getApplicationSymbolType());
        cmd.setParent((EObject)container);
        cmd.setLocation(new Rectangle(position.x, position.y, -1, -1));
        cmd.execute();
        return (ApplicationSymbolType)cmd.getModelElement();
    }

    private void createApplicationConnection(ISymbolContainer container, ActivitySymbolType activitySymbol, ApplicationSymbolType applicationSymbol) {
        String name = "executedBy";
        IdFactory idFactory = new IdFactory(name, name, String.valueOf(Long.toString(applicationSymbol.getElementOid())) + ":" + Long.toString(activitySymbol.getElementOid()));
        CreateConnectionSymbolCommand cmd = new CreateConnectionSymbolCommand(idFactory, CarnotWorkflowModelPackage.eINSTANCE.getExecutedByConnectionType());
        cmd.setParent((EObject)container);
        cmd.setSourceSymbol((INodeSymbol)applicationSymbol);
        cmd.setTargetSymbol((INodeSymbol)activitySymbol);
        cmd.setLabel(MessageFormat.format(JSF_Messages.LB_CONNECTION, name, applicationSymbol.getModelElement().getId(), activitySymbol.getModelElement().getId()));
        cmd.execute();
    }

    public void addPages() {
        this.page1 = new JSFGuiGenerationWizardPage1("Page 1", this.activity);
        this.page2 = new JSFGuiGenerationWizardPage2("Page 2");
        this.addPage(this.page1);
        this.addPage(this.page2);
    }

    private void updateDataMappings(List<GenericDataMapping> mappings) {
        for (GenericDataMapping genericDataMapping : mappings) {
            Class[] classArray;
            String prefix;
            DataMappingType mapping = genericDataMapping.getDataMapping();
            if (!"default".equals(mapping.getContext())) continue;
            mapping.setContext("jsf");
            String string = prefix = mapping.getDirection().equals((Object)DirectionType.IN_LITERAL) ? "set" : "get";
            if (mapping.getDirection().equals((Object)DirectionType.IN_LITERAL)) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = genericDataMapping.getMappedType().getMappedType();
            } else {
                classArray = new Class[]{};
            }
            Class[] args = classArray;
            String methodName = MethodDescriptor.encodeMethod((String)(String.valueOf(prefix) + genericDataMapping.getAccessorMethodsName()), (Class[])args);
            mapping.setApplicationAccessPoint(methodName);
        }
    }
}

