/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stardust.model.xpdl.carnot.EventConditionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;

public class EventHandlingUtils {
    public static Map findInstalledEventConditionTypes(boolean activityConditions, boolean processConditions) {
        HashMap<String, IConfigurationElement> items = new HashMap<String, IConfigurationElement>();
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        Map<String, IConfigurationElement> extensions = registry.getExtensions("conditionTypes");
        for (String id : extensions.keySet()) {
            IConfigurationElement extension = extensions.get(id);
            if (activityConditions && Boolean.toString(true).equalsIgnoreCase(extension.getAttribute("activityCondition"))) {
                items.put(id, extensions.get(id));
                continue;
            }
            if (!processConditions || !Boolean.toString(true).equalsIgnoreCase(extension.getAttribute("processCondition"))) continue;
            items.put(id, extensions.get(id));
        }
        return items;
    }

    public static IConfigurationElement findInstalledEventConditionType(String conditionTypeId, boolean activityConditions, boolean processConditions) {
        return (IConfigurationElement)EventHandlingUtils.findInstalledEventConditionTypes(activityConditions, processConditions).get(conditionTypeId);
    }

    public static Map findConfiguredEventConditionTypes(ModelType model, boolean activityConditions, boolean processConditions) {
        HashMap<String, EventConditionTypeType> types = new HashMap<String, EventConditionTypeType>();
        for (EventConditionTypeType conditionType : model.getEventConditionType()) {
            if (activityConditions && conditionType.isActivityCondition()) {
                types.put(conditionType.getId(), conditionType);
                continue;
            }
            if (!processConditions || !conditionType.isProcessCondition()) continue;
            types.put(conditionType.getId(), conditionType);
        }
        return types;
    }

    public static EventConditionTypeType findConfiguredEventConditionType(ModelType model, String conditionTypeId, boolean activityConditions, boolean processConditions) {
        return (EventConditionTypeType)EventHandlingUtils.findConfiguredEventConditionTypes(model, activityConditions, processConditions).get(conditionTypeId);
    }
}

