/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.ExtensionProviderUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.struct.ClientXPathMap;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.emfxsd.ClasspathUriConverter;
import org.eclipse.stardust.engine.core.struct.emfxsd.XPathFinder;
import org.eclipse.stardust.engine.core.struct.spi.ISchemaTypeProvider;
import org.eclipse.stardust.engine.extensions.dms.data.DmsConstants;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.Model_Messages;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class StructuredTypeUtils {
    public static final Pattern TRANSFORMATION_PATTERN = Pattern.compile("(DOM) *\\((.*)\\)");
    public static final Object[] emptyArray = new Object[0];

    public static IXPathMap getXPathMap(DataType data) {
        String dataTypeId = data.getType().getId();
        if (dataTypeId.equals("struct")) {
            TypeDeclarationType typeDeclarationType = StructuredTypeUtils.getTypeDeclaration(data);
            if (typeDeclarationType == null) {
                String message = Model_Messages.EXC_NO_TYPE_DECLARATION_SPECIFIED_FOR_DATA_NULL;
                throw new PublicException(MessageFormat.format(message, data.getId()));
            }
            return StructuredTypeUtils.getXPathMap(typeDeclarationType);
        }
        TypeDeclarationType metadataTypeDeclaration = StructuredTypeUtils.getCustomMetadataType(data, ModelUtils.findContainingModel(data));
        XSDNamedComponent metadataXsdComponent = null;
        if (metadataTypeDeclaration != null) {
            metadataXsdComponent = TypeDeclarationUtils.findElementOrTypeDeclaration(metadataTypeDeclaration);
        }
        Map parameters = CollectionUtils.newMap();
        parameters.put("metadataType", metadataXsdComponent);
        for (ISchemaTypeProvider.Factory stpFactory : ExtensionProviderUtils.getExtensionProviders(ISchemaTypeProvider.Factory.class)) {
            Set result;
            ISchemaTypeProvider provider = stpFactory.getSchemaTypeProvider(dataTypeId);
            if (provider == null || (result = provider.getSchemaType(dataTypeId, parameters)) == null) continue;
            return new ClientXPathMap(result);
        }
        String message = Model_Messages.EXC_COULD_NOT_FIND_PREDEFINED_XPATHS_FOR_DATA_TYPE_NULL;
        throw new InternalException(MessageFormat.format(message, dataTypeId));
    }

    public static TypeDeclarationType getTypeDeclaration(DataType data) {
        TypeDeclarationType typeDeclaration = null;
        ModelType model = ModelUtils.findContainingModel(data);
        ExternalReferenceType ref = data.getExternalReference();
        if (ref == null) {
            ModelType declarationModel;
            typeDeclaration = (TypeDeclarationType)AttributeUtil.getIdentifiable(data, "carnot:engine:dataType");
            if (typeDeclaration != null && model != (declarationModel = ModelUtils.findContainingModel(typeDeclaration)) && model != null) {
                typeDeclaration = StructuredTypeUtils.getTypeDeclaration(model, declarationModel.getId(), typeDeclaration.getId());
            }
        } else if (model != null) {
            typeDeclaration = StructuredTypeUtils.getTypeDeclaration(model, ref.getLocation(), ref.getXref());
        }
        return typeDeclaration;
    }

    public static TypeDeclarationType getTypeDeclaration(ModelType model, String packageId, String typeDeclarationId) {
        TypeDeclarationsType declarations;
        ModelType externalModel = StructuredTypeUtils.getExternalModel(model, packageId);
        if (externalModel != null && (declarations = externalModel.getTypeDeclarations()) != null) {
            return declarations.getTypeDeclaration(typeDeclarationId);
        }
        return null;
    }

    public static ModelType getExternalModel(ModelType model, String packageId) {
        ExternalPackages packages = model.getExternalPackages();
        ExternalPackage pkg = packages == null ? null : packages.getExternalPackage(packageId);
        IConnectionManager manager = model.getConnectionManager();
        return manager == null ? null : manager.find(pkg);
    }

    private static TypeDeclarationType getCustomMetadataType(IExtensibleElement element, ModelType model) {
        String metadataSchema;
        if (element != null && !StringUtils.isEmpty((String)(metadataSchema = AttributeUtil.getAttributeValue(element, DmsConstants.RESOURCE_METADATA_SCHEMA_ATT)))) {
            return model.getTypeDeclarations().getTypeDeclaration(metadataSchema);
        }
        return null;
    }

    public static IXPathMap getXPathMap(ModelType modelType, String declaredTypeId) {
        TypeDeclarationType t = modelType.getTypeDeclarations().getTypeDeclaration(declaredTypeId);
        return StructuredTypeUtils.getXPathMap(t);
    }

    public static IXPathMap getXPathMap(TypeDeclarationType typeDeclaration) {
        XSDSchema schema = typeDeclaration.getSchema();
        if (schema == null) {
            String message = Model_Messages.EXC_NEITHER_EXTERNAL_REFERENCE_NOR_SCHEME_TYPE_IS_SET_FOR_NULL;
            throw new RuntimeException(MessageFormat.format(message, typeDeclaration.getId()));
        }
        XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration(typeDeclaration);
        Set allXPaths = XPathFinder.findAllXPaths((XSDSchema)schema, (XSDNamedComponent)component);
        return new ClientXPathMap(allXPaths);
    }

    public static XSDSchema loadExternalSchemaFromClasspath(String schemaLocation) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map options = CollectionUtils.newMap();
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        resourceSet.setURIConverter((URIConverter)new ClasspathUriConverter());
        Resource resource = resourceSet.createResource(URI.createURI((String)("classpath:/" + schemaLocation)));
        try {
            resource.load(options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        EList l = resource.getContents();
        return (XSDSchema)l.get(0);
    }

    public static void setStructuredAccessPointAttributes(IExtensibleElement accessPoint, TypeDeclarationType type) {
        StructuredTypeUtils.setStructuredAccessPointAttributes(accessPoint, type, null);
    }

    public static void setStructuredAccessPointAttributes(IExtensibleElement accessPoint, TypeDeclarationType type, String transformationType) {
        AttributeUtil.setReference(accessPoint, "carnot:engine:dataType", type);
        if (!StringUtils.isEmpty((String)transformationType)) {
            AttributeUtil.setAttribute(accessPoint, "carnot:engine:transformation", transformationType);
        }
        AttributeUtil.setAttribute(accessPoint, "carnot:engine:path:separator", "/");
        AttributeUtil.setBooleanAttribute(accessPoint, "carnot:engine:data:bidirectional", true);
    }

    public static TypeDeclarationType getStructuredAccessPointTypeDeclaration(IExtensibleElement accessPoint) {
        return (TypeDeclarationType)AttributeUtil.getIdentifiable(accessPoint, "carnot:engine:dataType");
    }

    public static boolean isValidDomAccessPath(DataType dataType, String accessPath) {
        accessPath = accessPath.substring(4);
        accessPath = accessPath.substring(0, accessPath.length() - 1);
        IXPathMap xPathMap = StructuredTypeUtils.getXPathMap(dataType);
        boolean listOrPrimitive = StructuredDataXPathUtils.canReturnList((String)accessPath.toString(), (IXPathMap)xPathMap) || StructuredDataXPathUtils.returnsSinglePrimitive((String)accessPath.toString(), (IXPathMap)xPathMap);
        return !listOrPrimitive;
    }

    public static TypeDeclarationType getResourceTypeDeclaration() {
        TypeDeclarationType typeDeclaration = XpdlFactory.eINSTANCE.createTypeDeclarationType();
        typeDeclaration.setName("<default>");
        typeDeclaration.setId("ResourceProperty");
        SchemaTypeType schemaType = XpdlFactory.eINSTANCE.createSchemaTypeType();
        schemaType.setSchema(StructuredTypeUtils.loadExternalSchemaFromClasspath("org/eclipse/stardust/engine/extensions/dms/data/montauk-schema.xsd"));
        typeDeclaration.setSchemaType(schemaType);
        return typeDeclaration;
    }

    private StructuredTypeUtils() {
    }

    public static Object[] getFacets(TypeDeclarationType decl) {
        XSDEnumerationFacet effectiveFacet;
        XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration(decl);
        if (component instanceof XSDElementDeclaration) {
            component = ((XSDElementDeclaration)component).getTypeDefinition();
        }
        if (component instanceof XSDSimpleTypeDefinition && (effectiveFacet = ((XSDSimpleTypeDefinition)component).getEffectiveEnumerationFacet()) != null) {
            return effectiveFacet.getValue().toArray();
        }
        return emptyArray;
    }
}

