/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.swt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.stardust.modeling.common.ui.swt.MetadataManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableRowToolTipListener
implements Listener {
    Table table;
    Shell shell;
    Display display;
    Shell tip = null;
    Label label = null;
    Listener labelListener;
    Method getterMethod;

    public TableRowToolTipListener(final Table table, Class type, String propertyName) {
        try {
            this.getterMethod = type.getMethod(MetadataManager.getGetterMethodName(propertyName), null);
        }
        catch (SecurityException e1) {
            throw new RuntimeException(e1);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException(e1);
        }
        this.table = table;
        this.display = table.getDisplay();
        this.shell = table.getShell();
        this.labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        table.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        table.addListener(12, (Listener)this);
        table.addListener(1, (Listener)this);
        table.addListener(5, (Listener)this);
        table.addListener(32, (Listener)this);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: 
            case 5: 
            case 12: {
                if (this.tip == null) break;
                this.tip.dispose();
                this.tip = null;
                this.label = null;
                break;
            }
            case 32: {
                TableItem item = this.table.getItem(new Point(event.x, event.y));
                if (item == null) break;
                if (this.tip != null && !this.tip.isDisposed()) {
                    this.tip.dispose();
                }
                Object object = item.getData();
                String text = null;
                if (object != null) {
                    try {
                        Object value = this.getterMethod.invoke(object, null);
                        if (value == null) {
                            return;
                        }
                        text = value.toString();
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.tip = new Shell(this.shell, 540676);
                this.tip.setBackground(this.display.getSystemColor(29));
                FillLayout layout = new FillLayout();
                layout.marginWidth = 2;
                this.tip.setLayout((Layout)layout);
                this.label = new Label((Composite)this.tip, 0);
                this.label.setForeground(this.display.getSystemColor(28));
                this.label.setBackground(this.display.getSystemColor(29));
                this.label.setData("_TABLEITEM", (Object)item);
                this.label.setText(text);
                this.label.addListener(7, this.labelListener);
                this.label.addListener(3, this.labelListener);
                Point size = this.tip.computeSize(-1, -1);
                Rectangle rect = item.getBounds(0);
                Point pt = this.table.toDisplay(rect.x, rect.y);
                this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                this.tip.setVisible(true);
            }
        }
    }
}

