/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.compare;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.ResizableDialog;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceImpl;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.compare.ComparableModelElementNode;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;

public class ModelCompareDialog
extends ResizableDialog
implements IPropertyChangeListener {
    private CompareEditorInput fCompareEditorInput;
    private Button fCommitButton;

    public ModelCompareDialog(Shell shell, CompareEditorInput input) {
        super(shell, null);
        Assert.isNotNull((Object)input);
        this.fCompareEditorInput = input;
        this.fCompareEditorInput.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setHelpContextId("org.eclipse.compare.compare_dialog_context");
    }

    public boolean close() {
        if (super.close()) {
            if (this.fCompareEditorInput != null) {
                this.fCompareEditorInput.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            return true;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fCommitButton = this.createButton(parent, 0, Utilities.getString((String)"CompareDialog.commitAction.label"), true);
        this.fCommitButton.setEnabled(true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fCommitButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ModelCompareDialog.this.performFinish();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fCommitButton != null && this.fCompareEditorInput != null) {
            this.fCommitButton.setEnabled(this.fCompareEditorInput.isSaveNeeded());
        }
    }

    protected Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        Control c = this.fCompareEditorInput.createContents(parent);
        c.setLayoutData((Object)new GridData(1808));
        Shell shell = c.getShell();
        shell.setText(this.fCompareEditorInput.getTitle());
        shell.setImage(this.fCompareEditorInput.getTitleImage());
        ModelCompareDialog.applyDialogFont((Control)parent);
        return parent;
    }

    public int open() {
        int rc = super.open();
        if (rc == 0 && this.fCompareEditorInput.isSaveNeeded()) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor pm) throws CoreException {
                    ModelCompareDialog.this.fCompareEditorInput.saveChanges(pm);
                }
            };
            Shell shell = this.getParentShell();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            try {
                operation.run(pmd.getProgressMonitor());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InvocationTargetException x) {
                String title = Utilities.getString((String)"CompareDialog.saveErrorTitle");
                String msg = Utilities.getString((String)"CompareDialog.saveErrorMessage");
                MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(msg) + x.getTargetException().getMessage()));
            }
        }
        return rc;
    }

    private void performFinish() {
        final boolean[] result = new boolean[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "ISO-8859-1");
                        Resource resource = ModelCompareDialog.this.getMergedResource();
                        if (resource != null) {
                            if (resource.getURI().fileExtension().endsWith("xpdl") && resource instanceof CarnotWorkflowModelResourceImpl) {
                                Document domCwm = ((XMLResource)resource).save(null, options, null);
                                if (domCwm != null) {
                                    StreamSource xsltSource;
                                    try {
                                        URL xsltURL = XpdlUtils.getCarnot2XpdlStylesheet();
                                        if (xsltURL == null) {
                                            throw new InternalException("Unable to find XPDL export stylesheet.");
                                        }
                                        xsltSource = new StreamSource(xsltURL.openStream());
                                    }
                                    catch (IOException e) {
                                        throw new PublicException("Invalid JAXP setup", (Throwable)e);
                                    }
                                    ClassLoader cclBackup = Thread.currentThread().getContextClassLoader();
                                    try {
                                        try {
                                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                                            StreamResult target = new StreamResult(((CarnotWorkflowModelResourceImpl)resource).getNewOutputStream());
                                            TransformerFactory transformerFactory = XmlUtils.newTransformerFactory();
                                            Transformer xpdlTrans = transformerFactory.newTransformer(xsltSource);
                                            XmlUtils.transform((Source)new DOMSource(domCwm), (Transformer)xpdlTrans, (Result)target, null, (int)3, (String)"UTF-8");
                                        }
                                        catch (TransformerConfigurationException e) {
                                            throw new PublicException("Invalid JAXP setup", (Throwable)e);
                                        }
                                    }
                                    finally {
                                        Thread.currentThread().setContextClassLoader(cclBackup);
                                    }
                                }
                            } else {
                                resource.save(options);
                            }
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            String uri = resource.getURI().path();
                            if (uri.startsWith("/resource")) {
                                uri = uri.substring("/resource".length());
                            }
                            IFile file = (IFile)root.findMember((IPath)new Path(uri));
                            ModelCompareDialog.this.openEditor(monitor, file, true);
                        }
                        result[0] = true;
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            page.getWorkbenchWindow().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Diagram_Messages.MSG_Error, (String)realException.getMessage());
        }
    }

    private void openEditor(IProgressMonitor monitor, IFile file, boolean reopen) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IEditorPart part = page.findEditor((IEditorInput)new FileEditorInput(file));
            if (part != null && reopen) {
                page.closeEditor(part, true);
            }
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (PartInitException partInitException) {}
    }

    private Resource getMergedResource() {
        Resource resource = null;
        DiffNode node = (DiffNode)this.fCompareEditorInput.getCompareResult();
        if (node != null) {
            ComparableModelElementNode cNode = (ComparableModelElementNode)node.getLeft();
            resource = cNode.getEObject().eResource();
        }
        return resource;
    }
}

