/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.DynamicConnectionFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.GatewayFigure;
import org.eclipse.stardust.modeling.core.editors.figures.anchors.TransitionConnectionAnchor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.IConnectionCommand;

public class GatewaySymbolEditPart
extends AbstractNodeSymbolEditPart {
    public GatewaySymbolEditPart(WorkflowModelEditor editor, GatewaySymbol model) {
        super(editor, (INodeSymbol)model);
    }

    protected IFigure createFigure() {
        return new GatewayFigure(this);
    }

    @Override
    protected List getModelSourceConnections() {
        return ((GatewaySymbol)this.getModel()).getOutTransitions();
    }

    @Override
    protected List getModelTargetConnections() {
        ArrayList result;
        if (this.isShowingConnections()) {
            result = new ArrayList(super.getModelTargetConnections());
            result.addAll(((GatewaySymbol)this.getModel()).getInTransitions());
        } else {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getModel() instanceof TransitionConnectionType) {
            TransitionConnectionType tc = (TransitionConnectionType)connection.getModel();
            return new TransitionConnectionAnchor(this.getFigure(), tc.getSourceAnchor());
        }
        return super.getSourceConnectionAnchor(connection);
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getModel() instanceof TransitionConnectionType) {
            TransitionConnectionType tc = (TransitionConnectionType)connection.getModel();
            return new TransitionConnectionAnchor(this.getFigure(), tc.getTargetAnchor());
        }
        return super.getTargetConnectionAnchor(connection);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getNewObject() instanceof DynamicConnectionFactory) {
            DynamicConnectionFactory factory = (DynamicConnectionFactory)((CreateConnectionRequest)request).getNewObject();
            Point location = ((CreateConnectionRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            factory.setSourceAnchorType(anchor.getType());
            return anchor;
        }
        if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getNewObjectType().equals(CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType())) {
            IConnectionCommand cmd = (IConnectionCommand)((CreateConnectionRequest)request).getNewObject();
            Point location = ((CreateConnectionRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            cmd.setSourceAnchorType(anchor.getType());
            return anchor;
        }
        if (request instanceof ReconnectRequest && ((ReconnectRequest)request).getConnectionEditPart().getModel() instanceof TransitionConnectionType) {
            Point location = ((ReconnectRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            request.getExtendedData().put("org.eclipse.stardust.modeling.core.sourceAnchor", anchor.getType());
            return anchor;
        }
        return super.getSourceConnectionAnchor(request);
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getNewObject() instanceof DynamicConnectionFactory) {
            DynamicConnectionFactory factory = (DynamicConnectionFactory)((CreateConnectionRequest)request).getNewObject();
            Point location = ((CreateConnectionRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            factory.setTargetAnchorType(anchor.getType());
            return anchor;
        }
        if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getNewObjectType().equals(CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType())) {
            IConnectionCommand cmd = (IConnectionCommand)((CreateConnectionRequest)request).getNewObject();
            Point location = ((CreateConnectionRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            cmd.setTargetAnchorType(anchor.getType());
            return anchor;
        }
        if (request instanceof ReconnectRequest && ((ReconnectRequest)request).getConnectionEditPart().getModel() instanceof TransitionConnectionType) {
            Point location = ((ReconnectRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            request.getExtendedData().put("org.eclipse.stardust.modeling.core.targetAnchor", anchor.getType());
            return anchor;
        }
        return super.getTargetConnectionAnchor(request);
    }

    @Override
    public void handleNotification(Notification notification) {
        int featureId = notification.getFeatureID(CarnotWorkflowModelPackage.class);
        switch (featureId) {
            case 13: {
                this.refreshTargetConnections();
                break;
            }
            case 14: {
                this.refreshSourceConnections();
                break;
            }
            default: {
                super.handleNotification(notification);
            }
        }
    }

    @Override
    protected void refreshVisuals() {
        ActivityType activity;
        super.refreshVisuals();
        GatewayFigure figure = (GatewayFigure)this.getFigure();
        JoinSplitType type = JoinSplitType.XOR_LITERAL;
        GatewaySymbol gateway = (GatewaySymbol)this.getModel();
        ActivitySymbolType symbol = gateway.getActivitySymbol();
        FlowControlType flowKind = gateway.getFlowKind();
        if (symbol != null && (activity = (ActivityType)symbol.getModelElement()) != null) {
            String tooltip = "";
            switch (flowKind) {
                case JOIN_LITERAL: {
                    tooltip = MessageFormat.format(Diagram_Messages.TOOLTIP_JoinGateway, activity.getName());
                    type = activity.getJoin();
                    break;
                }
                case SPLIT_LITERAL: {
                    MessageFormat.format(Diagram_Messages.TOOLTIP_SplitGateway, activity.getName());
                }
                default: {
                    type = activity.getSplit();
                }
            }
            figure.setToolTip((IFigure)new Label(tooltip));
        }
        int typeIndicator = 0;
        switch (type) {
            case AND_LITERAL: {
                typeIndicator = 2;
                break;
            }
            case OR_LITERAL: {
                typeIndicator = 1;
            }
        }
        figure.setTypeIndicator(typeIndicator);
        figure.setKind(flowKind.getValue());
    }
}

