/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetAttributeReferenceCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.UndoablePropSheetEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class LaneParticipantCommandFactory
extends DefaultPropSheetCmdFactory {
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    public static final LaneParticipantCommandFactory INSTANCE = new LaneParticipantCommandFactory();

    @Override
    public Command createSetValueCommand(UndoablePropSheetEntry entry, IPropertyDescriptor descriptor, IPropertySource target, Object value) {
        if (value == null) {
            return this.createResetValueCommand(descriptor, target);
        }
        CompoundCommand result = new CompoundCommand(descriptor.getDisplayName());
        result.add(super.createSetValueCommand(entry, descriptor, target, value));
        this.addSetParticipantCommands(result, (LaneSymbol)target.getEditableValue(), (IModelParticipant)value);
        return result.unwrap();
    }

    @Override
    public Command createResetValueCommand(IPropertyDescriptor descriptor, IPropertySource target) {
        CompoundCommand result = new CompoundCommand(descriptor.getDisplayName());
        result.add(super.createResetValueCommand(descriptor, target));
        this.addSetParticipantCommands(result, (LaneSymbol)target.getEditableValue(), null);
        return result.unwrap();
    }

    private void addSetParticipantCommands(CompoundCommand command, LaneSymbol lane, IModelParticipant participant) {
        EList activitySymbols = lane.getActivitySymbol();
        int i = 0;
        while (i < activitySymbols.size()) {
            ActivitySymbolType activitySymbol = (ActivitySymbolType)activitySymbols.get(i);
            ActivityType activity = (ActivityType)activitySymbol.getModelElement();
            if (ActivityUtil.isInteractive((ActivityType)activity)) {
                LaneParticipantCommandFactory.addSetPerformerCommands(command, activity, participant, activity.getPerformer(), false, null);
            }
            ++i;
        }
        EList startEventSymbols = lane.getStartEventSymbols();
        for (StartEventSymbol startEventSymbol : startEventSymbols) {
            IdentifiableReference reference;
            TriggerType trigger = startEventSymbol.getTrigger();
            if ((trigger == null || trigger.getType() == null || !"manual".equals(trigger.getType().getId())) && (trigger == null || !"scan".equals(trigger.getType().getId()))) continue;
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)trigger, (String)"carnot:engine:participant");
            IModelParticipant element = null;
            if (attribute != null && (reference = attribute.getReference()) != null) {
                element = (IModelParticipant)reference.getIdentifiable();
            }
            LaneParticipantCommandFactory.addSetPerformerCommands(command, trigger, participant, element, attribute, false, null);
        }
    }

    public static void addSetPerformerCommands(CompoundCommand command, TriggerType trigger, IModelParticipant newPerformer, IModelParticipant originalPerformer, AttributeType attribute, boolean updateConnectionsOnly, EditPart target) {
        boolean setPerformer = false;
        if (!updateConnectionsOnly && newPerformer != originalPerformer && (target == null || originalPerformer == null || MessageDialog.openQuestion((Shell)target.getViewer().getControl().getShell(), (String)Diagram_Messages.MSG_DIA_SET_PERFORMANCER, (String)LaneParticipantCommandFactory.getMessage(newPerformer == null ? null : newPerformer.getName(), originalPerformer.getName(), trigger)))) {
            IdentifiableReference reference;
            setPerformer = true;
            boolean addAttribute = false;
            if (attribute == null) {
                addAttribute = true;
                attribute = AttributeUtil.createAttribute((String)"carnot:engine:participant");
            }
            if ((reference = attribute.getReference()) == null) {
                reference = CarnotWorkflowModelFactory.eINSTANCE.createIdentifiableReference();
                attribute.setReference(reference);
            }
            if (addAttribute) {
                command.add((Command)new SetValueCmd((EObject)trigger, (EStructuralFeature)CWM_PKG.getIExtensibleElement_Attribute(), (Object)attribute));
            }
            command.add((Command)new SetAttributeReferenceCmd(attribute, (EObject)newPerformer));
        }
        if (updateConnectionsOnly || setPerformer) {
            LaneParticipantCommandFactory.addUpdateConnectionsCommand(command, (IIdentifiableModelElement)trigger, (IIdentifiableModelElement)newPerformer, (IIdentifiableModelElement)originalPerformer, (EStructuralFeature)CWM_PKG.getStartEventSymbol_TriggersConnections(), LaneParticipantCommandFactory.getSymbolFeature(newPerformer), (EStructuralFeature)CWM_PKG.getTriggersConnectionType_ParticipantSymbol());
        }
    }

    public static void addSetPerformerCommands(CompoundCommand command, ActivityType activity, IModelParticipant newPerformer, IModelParticipant originalPerformer, boolean updateConnectionsOnly, EditPart target) {
        boolean setPerformer = false;
        if (!updateConnectionsOnly && newPerformer != originalPerformer && (target == null || originalPerformer == null || MessageDialog.openQuestion((Shell)target.getViewer().getControl().getShell(), (String)Diagram_Messages.MSG_DIA_SET_PERFORMANCER, (String)LaneParticipantCommandFactory.getMessage(newPerformer, originalPerformer, activity)))) {
            setPerformer = true;
            command.add((Command)new SetValueCmd((EObject)activity, (EStructuralFeature)CWM_PKG.getActivityType_Performer(), (Object)newPerformer));
        }
        if (updateConnectionsOnly || setPerformer) {
            LaneParticipantCommandFactory.addUpdateConnectionsCommand(command, (IIdentifiableModelElement)activity, (IIdentifiableModelElement)newPerformer, (IIdentifiableModelElement)originalPerformer, (EStructuralFeature)CWM_PKG.getActivitySymbolType_PerformsConnections(), LaneParticipantCommandFactory.getSymbolFeature(newPerformer), (EStructuralFeature)CWM_PKG.getPerformsConnectionType_ParticipantSymbol());
        }
    }

    private static String getMessage(IModelParticipant newPerformer, IModelParticipant originalPerformer, ActivityType activity) {
        String returnCondition1 = Diagram_Messages.TXT_REMOVE_PERFORMER_NULL_FROM_ACTIVITY_ONE;
        String returnCondition2 = Diagram_Messages.TXT_REPLACE_PERFORMER_NULL_WITH_PERFORMER_ONE_FOR_ACTIVITY_TWO;
        return newPerformer == null ? MessageFormat.format(returnCondition1, LaneParticipantCommandFactory.getPerformerName(originalPerformer), activity.getName()) : MessageFormat.format(returnCondition2, LaneParticipantCommandFactory.getPerformerName(originalPerformer), LaneParticipantCommandFactory.getPerformerName(newPerformer), activity.getName());
    }

    private static String getMessage(String newPerformer, String originalPerformer, TriggerType trigger) {
        return newPerformer == null ? MessageFormat.format(Diagram_Messages.MSG_REMOVE_PERFORMER_FROM_MANUAL_TRIGGER, originalPerformer, trigger.getName()) : MessageFormat.format(Diagram_Messages.MSG_RPLACE_PERFORMER_WITH_PERFORMER_FOR_TRIGGER, originalPerformer, newPerformer, trigger.getName());
    }

    public static String getPerformerName(IModelParticipant performer) {
        return performer == null ? "" : (performer.getName() != null ? performer.getName() : (performer.getId() != null ? performer.getId() : Long.toString(performer.getElementOid())));
    }

    private static EStructuralFeature getSymbolFeature(IModelParticipant newPerformer) {
        EReference symbolFeature = null;
        if (newPerformer instanceof RoleType) {
            symbolFeature = CWM_PKG.getISymbolContainer_RoleSymbol();
        } else if (newPerformer instanceof OrganizationType) {
            symbolFeature = CWM_PKG.getISymbolContainer_OrganizationSymbol();
        } else if (newPerformer instanceof ConditionalPerformerType) {
            symbolFeature = CWM_PKG.getISymbolContainer_ConditionalPerformerSymbol();
        }
        return symbolFeature;
    }
}

