/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.tools;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.swt.events.KeyEvent;

public class CarnotCreationTool
extends CreationTool {
    private Command creationCommand;

    public CarnotCreationTool() {
        this.setUnloadWhenFinished(true);
    }

    public CarnotCreationTool(CreationFactory factory) {
        super(factory);
        this.setUnloadWhenFinished(true);
    }

    protected void performCreation(int button) {
        this.creationCommand = this.getCurrentCommand();
        super.performCreation(button);
    }

    protected boolean updateTargetUnderMouse() {
        if (this.getCurrentViewer() == null) {
            return false;
        }
        return super.updateTargetUnderMouse();
    }

    protected void handleFinished() {
        if (this.unloadWhenFinished() && !this.getCurrentInput().isControlKeyDown()) {
            this.getDomain().loadDefaultTool();
        } else {
            this.reactivate();
        }
        if (0x40000000 == this.getState() && this.creationCommand != null) {
            INodeSymbol symbol = CarnotCreationTool.getCreatedSymbol(this.creationCommand);
            this.creationCommand = null;
            if (symbol != null) {
                CreationUtils.showInDiagramAndEdit(symbol);
            }
        }
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (e.keyCode == 262144) {
            this.getDomain().loadDefaultTool();
        }
        return super.handleKeyUp(e);
    }

    private static INodeSymbol getCreatedSymbol(Command command) {
        INodeSymbol symbol;
        block2: {
            block3: {
                symbol = null;
                if (!(command instanceof CompoundDiagramCommand)) break block3;
                for (Command child : ((CompoundDiagramCommand)command).getCommands()) {
                    if (!(child instanceof CreateSymbolCommand)) continue;
                    symbol = (INodeSymbol)((CreateSymbolCommand)child).getModelElement();
                    break block2;
                }
                break block2;
            }
            if (!(command instanceof CompoundCommand)) break block2;
            for (Command child : ((CompoundCommand)command).getCommands()) {
                if (!(child instanceof CompoundDiagramCommand)) continue;
                return CarnotCreationTool.getCreatedSymbol(child);
            }
        }
        return symbol;
    }
}

