/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    private static final DateFormat dateFormat = DateFormat.getDateInstance();
    private static final DateFormat timeFormat = DateFormat.getTimeInstance();
    private static final String DEFAULT_HOUR_SIGN = " h";
    private static final char LEADING_NULL_SIGN = '0';
    private static final char DEFAULT_DURATION_SEPARATOR = ':';

    public static SimpleDateFormat getNonInteractiveDateFormat() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
    }

    public static SimpleDateFormat getInteractiveDateFormat() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public static long getTimestamp(Date date, long def) {
        return date == null ? def : date.getTime();
    }

    public static String formatDateTime(Date date) {
        return date == null ? "" : String.valueOf(dateFormat.format(date)) + " " + timeFormat.format(date);
    }

    public static String formatDate(Date date) {
        return date == null ? "" : dateFormat.format(date);
    }

    public static String formatTime(Date date) {
        return date == null ? "" : timeFormat.format(date);
    }

    public static String formatDurationAsString(double durationInHours) {
        StringBuffer _durationString = new StringBuffer(15);
        Double _durationInSec = new Double(durationInHours * 3600.0);
        int _rest = _durationInSec.intValue();
        _durationString.append(_rest / 3600);
        _durationString.append(':');
        if ((_rest %= 3600) / 60 < 10) {
            _durationString.append('0');
        }
        _durationString.append(_rest / 60);
        _durationString.append(':');
        if ((_rest %= 60) < 10) {
            _durationString.append('0');
        }
        _durationString.append(_rest);
        _durationString.append(DEFAULT_HOUR_SIGN);
        return _durationString.toString();
    }
}

