/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ActionTypeUtil;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.EventHandlingTableContentProvider;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class EventHandlersPropertyPage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    public static final String EVENT_HANDLING_ID = "_cwm_eventhandling_";
    public static final int ADD_EVENT_ACTION_BUTTON = 4;
    public static final int ADD_BIND_ACTION_BUTTON = 5;
    public static final int ADD_UNBIND_ACTION_BUTTON = 6;
    private final String conditionTypeId;
    private final ConfigurationElement config;
    private final IButtonManager buttonController;
    private Button[] buttons;
    private Object selection;
    private TreeViewer viewer;

    public EventHandlersPropertyPage(ConfigurationElement config, IButtonManager buttonController) {
        this.config = config;
        this.buttonController = buttonController;
        this.conditionTypeId = config.getAttribute("id");
    }

    public IButtonManager getButtonController() {
        return this.buttonController;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.viewer.setInput((Object)element);
        this.updateButtons(null, this.buttons);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.getButtonController().createButtons(parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Object item = this.getSelectedItem();
            this.updateButtons(item != null ? item : this.config, this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public Object getSelection() {
        return this.selection == null ? this.getSelectedItem() : this.selection;
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        this.selection = selection;
        this.getButtonController().updateButtons(selection, buttons);
    }

    @Override
    public Button[] createButtons(Composite parent) {
        return this.getButtonController().createButtons(parent);
    }

    private Object getSelectedItem() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object selection = sel.getFirstElement();
        return selection;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        Tree tree = new Tree(composite, 67584);
        tree.setHeaderVisible(true);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.horizontalAlignment = 4;
        treeGridData.verticalAlignment = 4;
        tree.setLayoutData((Object)treeGridData);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlersPropertyPage.this.updateButtons(EventHandlersPropertyPage.this.getSelectedItem(), EventHandlersPropertyPage.this.buttons);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = EventHandlersPropertyPage.this.getSelectedItem();
                if (selection instanceof EventHandlerType || ActionTypeUtil.isAction((Object)selection)) {
                    EventHandlersPropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        this.viewer = new TreeViewer(tree);
        TableUtil.createColumns(tree, new String[]{Diagram_Messages.COL_NAME_Id, Diagram_Messages.COL_NAME_Name, Diagram_Messages.COL_NAME_Description});
        TableUtil.setInitialColumnSizes(tree, new int[]{35, 35, 30});
        EObjectLabelProvider provider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public String getText(String name, Object element) {
                if (name.equals("computed") && element instanceof EventHandlerType) {
                    EventHandlerType handler = (EventHandlerType)element;
                    StringBuffer sb = new StringBuffer();
                    boolean added = false;
                    added = this.addDescription(sb, handler.isAutoBind(), Diagram_Messages.DESC_autobound, added);
                    added = this.addDescription(sb, handler.isLogHandler(), Diagram_Messages.DESC_logHandler, added);
                    added = this.addDescription(sb, handler.isConsumeOnMatch(), Diagram_Messages.DESC_consumedOnMatch, added);
                    return sb.toString();
                }
                return super.getText(name, element);
            }

            private boolean addDescription(StringBuffer sb, boolean test, String name, boolean added) {
                if (added) {
                    sb.append(", ");
                }
                if (test) {
                    sb.append(name);
                }
                return test | added;
            }
        };
        TableUtil.setLabelProvider(this.viewer, (TableLabelProvider)provider, new String[]{"id", "name", "computed"});
        this.viewer.setContentProvider((IContentProvider)new EventHandlingTableContentProvider(this.conditionTypeId));
        return composite;
    }
}

