/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.triggerTypes.scan;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.IValidationStatus;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.validation.PageValidationManager;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.triggerTypes.scan.ParticipantPropertyPage;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ScanTriggerPropertyPage
extends AbstractModelElementPropertyPage {
    private IModelParticipant originalPerformer = null;
    private TriggerType trigger = null;
    private LabeledViewer dataCombo;
    private List<DataType> datas = new ArrayList<DataType>();
    private ModelType model;
    private LabeledText metaTypeText;
    private CarnotPreferenceNode participantNode;
    private CarnotPreferenceNode triggerNode;
    private boolean pageValidationManagerSet = false;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        TriggerType trigger;
        AttributeType attribute;
        AccessPointType apt;
        DataType dataType2;
        this.trigger = (TriggerType)element;
        this.model = ModelUtils.findContainingModel((EObject)element);
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)element);
        boolean supportsProcessAttachment = this.processSupportsProcessAttachments(process);
        this.datas.clear();
        for (DataType dataType2 : this.model.getData()) {
            if (!dataType2.getType().getId().equals("dmsDocument") && !dataType2.getType().getId().equals("dmsDocumentList")) continue;
            if (dataType2.getId().equals("PROCESS_ATTACHMENTS")) {
                if (!supportsProcessAttachment) continue;
                this.datas.add(dataType2);
                continue;
            }
            this.datas.add(dataType2);
        }
        this.dataCombo.getViewer().setInput(this.datas);
        if (!this.trigger.getAccessPoint().isEmpty() && (dataType2 = this.getSelectedDataType((apt = (AccessPointType)this.trigger.getAccessPoint().get(0)).getId())) != null) {
            this.dataCombo.getViewer().setSelection((ISelection)new StructuredSelection((Object)dataType2));
        }
        if ((attribute = AttributeUtil.getAttribute((IExtensibleElement)(trigger = (TriggerType)this.getModelElement()), (String)"carnot:engine:participant")) != null) {
            this.originalPerformer = (IModelParticipant)AttributeUtil.getReferenceElement((AttributeType)attribute);
        }
        this.validateParticipant(this.originalPerformer);
        this.validateTrigger();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    private DataType getSelectedDataType(String id) {
        for (DataType dt : this.model.getData()) {
            if (!dt.getId().equalsIgnoreCase(id)) continue;
            return dt;
        }
        return null;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.dataCombo = FormBuilder.createComboViewer((Composite)composite, (String)Diagram_Messages.LB_Data, new ArrayList());
        this.dataCombo.getViewer().getControl().setEnabled(this.enablePage);
        this.dataCombo.getViewer().setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataCombo.getViewer().setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.dataCombo.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                DataType dataType = (DataType)selection.getFirstElement();
                ScanTriggerPropertyPage.this.trigger.getAccessPoint().clear();
                if (dataType != null) {
                    AccessPointType apt = AccessPointUtil.createAccessPoint((String)dataType.getId(), (String)dataType.getName(), (DirectionType)DirectionType.OUT_LITERAL, (DataTypeType)dataType.getType());
                    ScanTriggerPropertyPage.this.trigger.getAccessPoint().add((Object)apt);
                    ParameterMappingType parameterMappingType = CarnotWorkflowModelFactory.eINSTANCE.createParameterMappingType();
                    TriggerType trigger = (TriggerType)ScanTriggerPropertyPage.this.getModelElement();
                    trigger.getParameterMapping().clear();
                    trigger.getParameterMapping().add((Object)parameterMappingType);
                    parameterMappingType.setData(dataType);
                    parameterMappingType.setParameter(dataType.getId());
                    String typeName = AttributeUtil.getAttributeValue((List)dataType.getAttribute(), (String)"carnot:engine:dms:resourceMetadataSchema");
                    if (typeName == null) {
                        typeName = "Default";
                    }
                    ScanTriggerPropertyPage.this.metaTypeText.getText().setText(typeName);
                }
                ScanTriggerPropertyPage.this.validateTrigger();
            }
        });
        this.metaTypeText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_MetaType);
        this.metaTypeText.getText().setEnabled(false);
        String iconName = "{org.eclipse.stardust.modeling.core}icons/full/obj16/participants.gif";
        ConfigurationElement element = ConfigurationElement.createPageConfiguration("org.eclipse.stardust.modeling.core.spi.triggerTypes.scan.ParticipantPropertyPage", Diagram_Messages.LB_Participants, iconName, ParticipantPropertyPage.class);
        this.participantNode = new CarnotPreferenceNode(element, this.getElement(), 0);
        this.getPreferenceManager().addToRoot((IPreferenceNode)this.participantNode);
        this.triggerNode = (CarnotPreferenceNode)this.getPreferenceManager().find("scan");
        return composite;
    }

    private void validateParticipant(IModelParticipant performer) {
        if (performer != null) {
            this.setParticipantValidationState(IQuickValidationStatus.OK);
        } else {
            this.setParticipantValidationState(IQuickValidationStatus.ERRORS);
        }
    }

    private void validateTrigger() {
        if (!this.trigger.getAccessPoint().isEmpty()) {
            this.setTriggerValidationState(IQuickValidationStatus.OK);
            this.dataCombo.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        } else {
            this.setTriggerValidationState(IQuickValidationStatus.ERRORS);
            this.dataCombo.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
        }
    }

    private void setParticipantValidationState(IQuickValidationStatus state) {
        this.participantNode.updatePageStatus(state);
        TreeViewer parentTreeViewer = (TreeViewer)Reflect.getFieldValue((Object)this.getContainer(), (String)"treeViewer");
        parentTreeViewer.refresh(true);
    }

    private void setTriggerValidationState(IQuickValidationStatus state) {
        this.triggerNode.updatePageStatus(state);
        TreeViewer parentTreeViewer = (TreeViewer)Reflect.getFieldValue((Object)this.getContainer(), (String)"treeViewer");
        parentTreeViewer.refresh(true);
    }

    public boolean performCancel() {
        AttributeUtil.setReference((IExtensibleElement)this.trigger, (String)"carnot:engine:participant", (EObject)this.originalPerformer);
        return super.performCancel();
    }

    @Override
    public WidgetBindingManager getWidgetBindingManager() {
        if (!this.pageValidationManagerSet) {
            this.pageValidationManagerSet = true;
            WidgetBindingManager wBndMgr = super.getWidgetBindingManager();
            PageValidationManager pm = new PageValidationManager((IPreferencePage)this){

                @Override
                public void onIssuesUpdated(EObject element, IValidationStatus validationStatus) {
                }
            };
            Reflect.setFieldValue((Object)wBndMgr, (String)"vBndMgr", (Object)pm);
            return wBndMgr;
        }
        return super.getWidgetBindingManager();
    }

    private boolean processSupportsProcessAttachments(ProcessDefinitionType process) {
        boolean inPath = false;
        boolean outPath = false;
        for (DataPathType dataPath : process.getDataPath()) {
            if (!"PROCESS_ATTACHMENTS".equals(dataPath.getId())) continue;
            if (DirectionType.IN_LITERAL.equals((Object)dataPath.getDirection())) {
                inPath = true;
            }
            if (!DirectionType.OUT_LITERAL.equals((Object)dataPath.getDirection())) continue;
            outPath = true;
        }
        return inPath && outPath;
    }
}

